/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.openmfa.service;

import hudson.util.Secret;
import io.jenkins.plugins.openmfa.base.MFAException;
import io.jenkins.plugins.openmfa.base.Service;
import io.jenkins.plugins.openmfa.constant.TOTPConstants;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.commons.codec.binary.Base32;

@Service
public class TOTPService {
    @Generated
    private static final Logger log = Logger.getLogger(TOTPService.class.getName());
    private static final int CLEANUP_INTERVAL = 100;
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private final Map<String, Long> usedCodes = new ConcurrentHashMap<String, Long>();
    private int verificationCount = 0;

    public Secret generateSecret() {
        byte[] bytes = new byte[20];
        SECURE_RANDOM.nextBytes(bytes);
        Base32 base32 = new Base32();
        return Secret.fromString((String)base32.encodeToString(bytes));
    }

    public String generateTOTP(Secret secret) {
        return this.generateTOTP(secret, System.currentTimeMillis() / 1000L / 30L);
    }

    public String generateTOTP(Secret secret, long step) {
        Base32 base32 = new Base32();
        byte[] bytes = base32.decode(secret.getPlainText());
        String hexKey = this.bytesToHex(bytes);
        String hexTime = Long.toHexString(step);
        return this.generateTOTP(hexKey, hexTime, 6);
    }

    public String getProvisioningUri(String username, Secret secret, String issuer) {
        String secretPlainText = secret.getPlainText();
        return String.format("otpauth://totp/%s:%s?secret=%s&issuer=%s", issuer, username, secretPlainText.replace("=", ""), issuer);
    }

    public boolean validateTOTP(Secret secret, String code) {
        return this.verifyCode(secret, code);
    }

    public boolean verifyCode(Secret secret, String code) {
        if (code == null || code.length() != 6) {
            return false;
        }
        if (++this.verificationCount % 100 == 0) {
            this.cleanupExpiredCodes();
        }
        try {
            long currentStep = System.currentTimeMillis() / 1000L / 30L;
            for (int i = -1; i <= 1; ++i) {
                String generatedCode = this.generateTOTP(secret, currentStep + (long)i);
                if (!generatedCode.equals(code)) continue;
                String cacheKey = this.generateCacheKey(secret, code);
                Long existingExpiry = this.usedCodes.get(cacheKey);
                if (existingExpiry != null && System.currentTimeMillis() < existingExpiry) {
                    log.warning("TOTP replay attack detected - code already used");
                    return false;
                }
                long expiryTime = (currentStep + 1L + 1L) * 30L * 1000L;
                this.usedCodes.put(cacheKey, expiryTime);
                log.fine("TOTP code verified and marked as used");
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    private void cleanupExpiredCodes() {
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<String, Long>> iterator = this.usedCodes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Long> entry = iterator.next();
            if (entry.getValue() >= now) continue;
            iterator.remove();
        }
        log.fine(String.format("Cleaned up expired TOTP codes, remaining: %d", this.usedCodes.size()));
    }

    private String generateCacheKey(Secret secret, String code) {
        return secret.getPlainText().hashCode() + ":" + code;
    }

    private String generateTOTP(String key, String step, int len) {
        try {
            StringBuilder paddedStep = new StringBuilder(step);
            while (paddedStep.length() < 16) {
                paddedStep.insert(0, "0");
            }
            log.fine("Padded step: " + paddedStep.toString());
            byte[] msg = this.hexStringToByteArray(paddedStep.toString());
            byte[] k = this.hexStringToByteArray(key);
            byte[] hash = this.hmacSha("HmacSHA1", k, msg);
            int offset = hash[hash.length - 1] & 0xF;
            int binary = (hash[offset] & 0x7F) << 24 | (hash[offset + 1] & 0xFF) << 16 | (hash[offset + 2] & 0xFF) << 8 | hash[offset + 3] & 0xFF;
            int otp = binary % TOTPConstants.DIGITS_POWER.get(len);
            StringBuilder result = new StringBuilder(Integer.toString(otp));
            while (result.length() < len) {
                result.insert(0, "0");
            }
            return result.toString();
        }
        catch (Exception e) {
            throw new MFAException("Error generating TOTP", e);
        }
    }

    private byte[] hexStringToByteArray(String s) {
        Object hexString = s;
        if (s.length() % 2 != 0) {
            hexString = "0" + s;
        }
        int len = ((String)hexString).length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(((String)hexString).charAt(i), 16) << 4) + Character.digit(((String)hexString).charAt(i + 1), 16));
        }
        return data;
    }

    private byte[] hmacSha(String crypto, byte[] keyBytes, byte[] text) {
        try {
            Mac hmac = Mac.getInstance(crypto);
            SecretKeySpec macKey = new SecretKeySpec(keyBytes, "RAW");
            hmac.init(macKey);
            return hmac.doFinal(text);
        }
        catch (Exception e) {
            throw new MFAException("Error generating HMAC", e);
        }
    }
}

