/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.openmfa;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import hudson.model.InvisibleAction;
import hudson.model.User;
import hudson.util.Secret;
import io.jenkins.plugins.openmfa.MFAGlobalConfiguration;
import io.jenkins.plugins.openmfa.MFAUserProperty;
import io.jenkins.plugins.openmfa.base.MFAContext;
import io.jenkins.plugins.openmfa.service.SessionService;
import io.jenkins.plugins.openmfa.service.TOTPService;
import io.jenkins.plugins.openmfa.util.JenkinsUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import lombok.Generated;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class MFASetupAction
extends InvisibleAction {
    @Generated
    private static final Logger log = Logger.getLogger(MFASetupAction.class.getName());
    private final User targetUser;

    public MFASetupAction(User targetUser) {
        this.targetUser = targetUser;
    }

    @RequirePOST
    public HttpResponse doDisable() throws IOException {
        this.requireCanConfigureTargetUser();
        if (MFAGlobalConfiguration.get().isRequireMFA()) {
            return HttpResponses.redirectTo((String)"?error=require_mfa");
        }
        MFAUserProperty property = MFAUserProperty.forUser(this.targetUser);
        if (property != null) {
            property.setSecret(null);
            this.targetUser.save();
            log.info(String.format("MFA disabled for user: %s", this.targetUser.getId()));
        }
        return HttpResponses.redirectTo((String)"?success=disabled");
    }

    @RequirePOST
    public HttpResponse doEnable() throws IOException {
        this.requireCanConfigureTargetUser();
        StaplerRequest2 req = Stapler.getCurrentRequest2();
        String secretParam = req.getParameter("x-plugin-openmfa-secret");
        String code = req.getParameter("x-plugin-openmfa-code");
        Secret secret = Secret.fromString((String)secretParam);
        TOTPService totpService = MFAContext.i().getService(TOTPService.class);
        if (!totpService.verifyCode(secret, code)) {
            return HttpResponses.redirectTo((String)"?error=invalid_code");
        }
        MFAUserProperty property = MFAUserProperty.getOrCreate(this.targetUser);
        property.setSecret(secret);
        this.targetUser.save();
        log.info(String.format("MFA enabled for user: %s", this.targetUser.getId()));
        MFAContext.i().getService(SessionService.class).verifySession((HttpServletRequest)req);
        return HttpResponses.redirectTo((String)"?success=enabled");
    }

    public String generateQRCode(String username, String encryptedSecret) {
        try {
            Secret secret = Secret.fromString((String)encryptedSecret);
            String issuer = "Jenkins";
            TOTPService totpService = MFAContext.i().getService(TOTPService.class);
            String uri = totpService.getProvisioningUri(username, secret, issuer);
            QRCodeWriter qrCodeWriter = new QRCodeWriter();
            BitMatrix bitMatrix = qrCodeWriter.encode(uri, BarcodeFormat.QR_CODE, 300, 300);
            BufferedImage image = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "PNG", baos);
            byte[] imageBytes = baos.toByteArray();
            return "data:image/png;base64," + Base64.getEncoder().encodeToString(imageBytes);
        }
        catch (WriterException | IOException e) {
            log.log(Level.SEVERE, "Error generating QR code", e);
            return null;
        }
    }

    public String generateSecret() {
        TOTPService totpService = MFAContext.i().getService(TOTPService.class);
        return totpService.generateSecret().getEncryptedValue();
    }

    public String getCodePlaceholder() {
        StringBuilder placeholder = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            placeholder.append("0");
        }
        return placeholder.toString();
    }

    public User getCurrentUser() {
        return this.getTargetUser();
    }

    public String getFormParamCode() {
        return "x-plugin-openmfa-code";
    }

    public String getFormParamSecret() {
        return "x-plugin-openmfa-secret";
    }

    public MFAUserProperty getMFAProperty() throws IOException {
        this.requireCanConfigureTargetUser();
        if (this.targetUser == null) {
            return null;
        }
        return MFAUserProperty.getOrCreate(this.targetUser);
    }

    public User getTargetUser() {
        return this.targetUser;
    }

    public int getTotpCodeDigits() {
        return 6;
    }

    public String getUrlName() {
        return "mfa-setup";
    }

    private boolean canConfigureTargetUser() {
        if (this.targetUser == null) {
            return false;
        }
        User current = User.current();
        if (current != null && current.getId() != null && current.getId().equals(this.targetUser.getId())) {
            return true;
        }
        return JenkinsUtil.isAdmin();
    }

    private void requireCanConfigureTargetUser() throws HttpResponses.HttpResponseException {
        if (!this.canConfigureTargetUser()) {
            throw HttpResponses.forbidden();
        }
    }
}

