/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.openmfa;

import hudson.Extension;
import hudson.model.User;
import io.jenkins.plugins.openmfa.base.MFAContext;
import io.jenkins.plugins.openmfa.service.SessionService;
import io.jenkins.plugins.openmfa.util.JenkinsUtil;
import io.jenkins.plugins.openmfa.util.SecurityUtil;
import io.jenkins.plugins.openmfa.util.TOTPUtil;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import jenkins.security.BasicHeaderApiTokenAuthenticator;
import lombok.Generated;

@Extension
public class MFAFilter
implements Filter {
    @Generated
    private static final Logger log = Logger.getLogger(MFAFilter.class.getName());
    private static final List<String> ALLOWED_PATHS = Arrays.asList("/login", "/loginError", "/logout", "/securityRealm", "/adjuncts/", "/assets/", "/static/", "/images/", "/css/", "/scripts/", "/mfa-login", "/mfa-setup", "/mfa-login/verify");
    private SessionService sessionService = MFAContext.i().getService(SessionService.class);

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            chain.doFilter(request, response);
            log.fine("");
            return;
        }
        if (Boolean.TRUE.equals(request.getAttribute(BasicHeaderApiTokenAuthenticator.class.getName()))) {
            log.fine("Authenticated via API token, skipping MFA check");
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        Optional<User> user = JenkinsUtil.getCurrentUser();
        log.fine("Current user: " + user.map(User::getId).orElse("<anonymous>"));
        if (user.isEmpty() || this.shouldAllowPath(req)) {
            log.fine("Allowing path without MFA check: " + req.getRequestURI());
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        if (this.sessionService.isVerifiedSession(req.getSession(false))) {
            log.fine("Session already verified, allowing access");
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        if (!this.handleMFAVerification(req, resp, user.get())) {
            return;
        }
        chain.doFilter((ServletRequest)req, (ServletResponse)resp);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    private String buildFromParam(HttpServletRequest req) {
        String query;
        String uri = req.getRequestURI();
        String contextPath = req.getContextPath();
        Object relativePath = uri;
        if (contextPath != null && !contextPath.isEmpty() && uri.startsWith(contextPath)) {
            relativePath = uri.substring(contextPath.length());
        }
        if (((String)relativePath).isEmpty()) {
            relativePath = "/";
        }
        if ((query = req.getQueryString()) != null && !query.isEmpty()) {
            relativePath = (String)relativePath + "?" + query;
        }
        try {
            return "&from=" + URLEncoder.encode((String)relativePath, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return "";
        }
    }

    private boolean handleMFAVerification(HttpServletRequest req, HttpServletResponse resp, User user) throws IOException {
        String username = user.getId();
        if (!TOTPUtil.isMFAEnabled()) {
            if (TOTPUtil.isMFARequired()) {
                resp.sendRedirect(SecurityUtil.buildSetupURI(req.getContextPath(), username));
                return false;
            }
            return true;
        }
        HttpSession session = req.getSession(true);
        if (MFAContext.i().getService(SessionService.class).isVerifiedSession(session)) {
            log.fine(String.format("MFA already verified for user: %s", username));
            return true;
        }
        log.fine(String.format("MFA required for user: %s, current path: %s, redirecting to MFA page", username, req.getRequestURI()));
        session.setAttribute("X-Plugin-OpenMFA-Pending-Auth", (Object)username);
        String fromParam = this.buildFromParam(req);
        String mfaLoginUrl = req.getContextPath() + "/mfa-login" + (String)(fromParam.isEmpty() ? "" : "?" + fromParam.substring(1));
        resp.sendRedirect(mfaLoginUrl);
        return false;
    }

    private boolean shouldAllowPath(HttpServletRequest req) {
        String uri = req.getRequestURI();
        String contextPath = req.getContextPath();
        String relativePath = uri;
        if (contextPath != null && !contextPath.isEmpty() && uri.startsWith(contextPath)) {
            relativePath = uri.substring(contextPath.length());
        }
        for (String allowedPath : ALLOWED_PATHS) {
            if (relativePath.equals(allowedPath)) {
                return true;
            }
            if (allowedPath.endsWith("/") && relativePath.startsWith(allowedPath)) {
                return true;
            }
            if (allowedPath.endsWith("/") || !relativePath.startsWith(allowedPath + "/") && !relativePath.startsWith(allowedPath + "?")) continue;
            return true;
        }
        return relativePath.matches("^/user/[^/]+/mfa-setup($|/.*)");
    }
}

