package io.jenkins.plugins.neuvector;

import com.google.common.base.Strings;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.io.Serializable;

import hudson.util.FormValidation;
import hudson.util.Secret;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import jenkins.model.Jenkins;

import java.util.Iterator;
import java.util.List;


public class Registry extends AbstractDescribableImpl<Registry> implements Serializable {

    private static final long serialVersionUID = 1L;
    private String nickname;
    private String regUrl;
    private String regUsername;
    private Secret regPassword;

    @DataBoundConstructor
    public Registry(String nickname, String regUrl, String regUsername, Secret regPassword) {
        this.nickname = nickname.trim();
        this.regUrl = regUrl.trim();
        this.regUsername = regUsername.trim();
        this.regPassword = regPassword;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getNickname() {
        return nickname;
    }

    public void setRegUrl(String regUrl) {
        this.regUrl = regUrl;  // Setter for UUID
    }

    public String getRegUrl() {
        return regUrl;
    }

    public void setRegUsername(String regUsername) {
        this.regUsername = regUsername;  // Setter for UUID
    }

    public String getRegUsername() {
        return regUsername;
    }


    public void setRegPassword(Secret regPassword) {
        this.regPassword = regPassword;  // Setter for UUID
    }
    public Secret getRegPassword() {
        return regPassword;
    }
    @Extension
    public static class DescriptorImpl extends Descriptor<Registry> {
        private final NeuVectorBuilder.DescriptorImpl globalConfig = Jenkins.get().getDescriptorByType(NeuVectorBuilder.DescriptorImpl.class);
        @Override
        public String getDisplayName() {
            return "Add Registry";
        }
        
        public DescriptorImpl() {
            super.load();
        }

        public FormValidation doCheckNickname(@QueryParameter String nickname) {
            if (Strings.isNullOrEmpty(nickname) || nickname.trim().isEmpty()) {
                return FormValidation.error(Messages.Registry_DescriptorImpl_errors_nickname());
            }
            return FormValidation.ok();
        }

        public FormValidation doDeleteRegistry(@QueryParameter String nickname) {
            // Ensure user has permission
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            List<Registry> registries = globalConfig.getRegistries();
    
            Iterator<Registry> iterator = registries.iterator();
            while (iterator.hasNext()) {
                Registry endpoint = iterator.next();
                if (endpoint.getNickname().equals(nickname)) {
                    iterator.remove();
                    globalConfig.save();
                }
            }
            return FormValidation.ok("Deleted successfully");
        }

        public FormValidation doCheckRegUrl(@QueryParameter String value) {
            if (Strings.isNullOrEmpty(value) || value.trim().isEmpty() || !value.trim().matches("^(http|https)://.*$")) {
                return FormValidation.error(Messages.Registry_DescriptorImpl_errors_regUrl());
            }
            return FormValidation.ok();
        }

        @Override
        public synchronized void save() {
            super.save();
        }
    }
}