/*
 * Decompiled with CFR 0.152.
 */
package org.miniorange.saml;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.security.HudsonPrivateSecurityRealm;
import hudson.security.SecurityRealm;
import hudson.tasks.Mailer;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jenkins.model.Jenkins;
import jenkins.security.SecurityListener;
import net.sf.json.JSONArray;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Header;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.kohsuke.stapler.verb.POST;
import org.miniorange.saml.MoAttribute;
import org.miniorange.saml.MoAttributeEntry;
import org.miniorange.saml.MoHttpUtils;
import org.miniorange.saml.MoIDPMetadata;
import org.miniorange.saml.MoSAMLAuthenticationTokenInfo;
import org.miniorange.saml.MoSAMLException;
import org.miniorange.saml.MoSAMLManager;
import org.miniorange.saml.MoSAMLPluginSettings;
import org.miniorange.saml.MoSAMLResponse;
import org.miniorange.saml.MoSAMLTemplateManager;
import org.miniorange.saml.MoSAMLUserInfo;
import org.miniorange.saml.MoSAMLUtils;
import org.miniorange.saml.MoSAMLuserProperty;
import org.miniorange.saml.testConfiguration.TestConfigurationFailed;
import org.opensaml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml2.metadata.ContactPerson;
import org.opensaml.saml2.metadata.ContactPersonTypeEnumeration;
import org.opensaml.saml2.metadata.EmailAddress;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.GivenName;
import org.opensaml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml2.metadata.LocalizedString;
import org.opensaml.saml2.metadata.NameIDFormat;
import org.opensaml.saml2.metadata.Organization;
import org.opensaml.saml2.metadata.OrganizationDisplayName;
import org.opensaml.saml2.metadata.OrganizationName;
import org.opensaml.saml2.metadata.OrganizationURL;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml2.metadata.impl.AssertionConsumerServiceBuilder;
import org.opensaml.saml2.metadata.impl.ContactPersonBuilder;
import org.opensaml.saml2.metadata.impl.EmailAddressBuilder;
import org.opensaml.saml2.metadata.impl.EntityDescriptorBuilder;
import org.opensaml.saml2.metadata.impl.GivenNameBuilder;
import org.opensaml.saml2.metadata.impl.KeyDescriptorBuilder;
import org.opensaml.saml2.metadata.impl.NameIDFormatBuilder;
import org.opensaml.saml2.metadata.impl.OrganizationBuilder;
import org.opensaml.saml2.metadata.impl.OrganizationDisplayNameBuilder;
import org.opensaml.saml2.metadata.impl.OrganizationNameBuilder;
import org.opensaml.saml2.metadata.impl.OrganizationURLBuilder;
import org.opensaml.saml2.metadata.impl.SPSSODescriptorBuilder;
import org.opensaml.saml2.metadata.impl.SingleLogoutServiceBuilder;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallerFactory;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.X509Certificate;
import org.opensaml.xml.signature.X509Data;
import org.opensaml.xml.signature.impl.KeyInfoBuilder;
import org.opensaml.xml.signature.impl.X509CertificateBuilder;
import org.opensaml.xml.signature.impl.X509DataBuilder;
import org.opensaml.xml.util.XMLHelper;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MoSAMLAddIdp
extends SecurityRealm {
    private static final Logger LOGGER = Logger.getLogger(MoSAMLAddIdp.class.getName());
    public static final String MO_SAML_SP_AUTH_URL = "securityRealm/moSamlAuth";
    public static final String MO_JENKINS_LOGIN_ACTION = "securityRealm/moLoginAction";
    public static final String MO_JENKINS_SAML_LOGIN_ACTION = "securityRealm/moSamlLogin";
    public static final String MO_SAML_SSO_FORCE_STOP = "securityRealm/moSAMLSingleSignOnForceStop";
    private static final String LOGIN_TEMPLATE_PATH = "/templates/mosaml_login_page_template.html";
    private static final String REFERER_ATTRIBUTE = MoSAMLAddIdp.class.getName() + ".referer";
    private final String idpEntityId;
    private final String ssoUrl;
    private final String metadataUrl;
    private final String metadataFilePath;
    private final String publicx509Certificate;
    private final String usernameAttribute;
    private final String fullnameAttribute;
    private final String usernameCaseConversion;
    private final Boolean userAttributeUpdate;
    private final String emailAttribute;
    private final String nameIDFormat;
    private final String sslUrl;
    private final String loginType;
    private final String regexPattern;
    private final Boolean enableRegexPattern;
    private final Boolean signedRequest;
    private final Boolean splitnameAttribute;
    private final Boolean userCreate;
    private final Boolean forceAuthn;
    private final String ssoBindingType;
    private final String sloBindingType;
    private List<MoAttributeEntry> samlCustomAttributes;
    private String newUserGroup;
    private String authnContextClass;
    private static Set<String> nonceSet = new HashSet<String>();
    private transient TestConfigurationFailed tcf;
    private String crowdURL;
    private String crowdApplicationName;
    private Secret crowdApplicationPassword;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public MoSAMLAddIdp(String idpEntityId, String ssoUrl, String metadataUrl, String metadataFilePath, String publicx509Certificate, String usernameCaseConversion, String usernameAttribute, String emailAttribute, String fullnameAttribute, String nameIDFormat, String sslUrl, String loginType, String regexPattern, Boolean enableRegexPattern, Boolean signedRequest, Boolean splitnameAttribute, Boolean userCreate, Boolean forceAuthn, String ssoBindingType, String sloBindingType, List<MoAttributeEntry> samlCustomAttributes, Boolean userAttributeUpdate, String authnContextClass, String crowdURL, String crowdApplicationName, Secret crowdApplicationPassword) throws Exception {
        this.metadataUrl = metadataUrl;
        this.metadataFilePath = metadataFilePath;
        if (!StringUtils.isEmpty((String)metadataUrl) || !StringUtils.isEmpty((String)metadataFilePath)) {
            String metadata = !StringUtils.isEmpty((String)metadataUrl) ? MoHttpUtils.sendGetRequest(metadataUrl, null) : MoSAMLAddIdp.getMetadataFromFile(metadataFilePath);
            List<String> metadataUrlValues = MoSAMLAddIdp.configureFromMetadata(metadata);
            if (metadataUrlValues.size() != 0) {
                this.idpEntityId = metadataUrlValues.get(0);
                this.nameIDFormat = metadataUrlValues.get(1);
                this.ssoUrl = metadataUrlValues.get(2);
                this.sslUrl = "";
                this.publicx509Certificate = metadataUrlValues.get(4);
            } else {
                this.idpEntityId = idpEntityId;
                this.ssoUrl = ssoUrl;
                this.nameIDFormat = nameIDFormat;
                this.sslUrl = sslUrl;
                this.publicx509Certificate = publicx509Certificate;
            }
        } else {
            this.idpEntityId = idpEntityId;
            this.ssoUrl = ssoUrl;
            this.nameIDFormat = nameIDFormat;
            this.sslUrl = sslUrl;
            this.publicx509Certificate = publicx509Certificate;
        }
        this.usernameCaseConversion = usernameCaseConversion != null ? usernameCaseConversion : "none";
        this.usernameAttribute = usernameAttribute != null && !usernameAttribute.trim().equals("") ? usernameAttribute : "NameID";
        this.emailAttribute = emailAttribute != null && !emailAttribute.trim().equals("") ? emailAttribute : "NameID";
        this.loginType = loginType != null ? loginType : "usernameLogin";
        this.regexPattern = regexPattern;
        this.enableRegexPattern = enableRegexPattern != null ? enableRegexPattern : false;
        this.signedRequest = signedRequest != null ? signedRequest : false;
        this.splitnameAttribute = splitnameAttribute != null ? splitnameAttribute : false;
        this.userCreate = userCreate != null ? userCreate : true;
        this.forceAuthn = forceAuthn != null ? forceAuthn : false;
        this.ssoBindingType = ssoBindingType != null ? ssoBindingType : "HttpRedirect";
        this.sloBindingType = sloBindingType != null ? sloBindingType : "HttpRedirect";
        this.samlCustomAttributes = samlCustomAttributes;
        this.userAttributeUpdate = userAttributeUpdate != null ? userAttributeUpdate : false;
        this.fullnameAttribute = fullnameAttribute;
        this.authnContextClass = authnContextClass != null ? authnContextClass : "None";
        this.crowdURL = crowdURL;
        this.crowdApplicationName = crowdApplicationName;
        this.crowdApplicationPassword = crowdApplicationPassword;
    }

    public String getLoginUrl() {
        return "securityRealm/moLogin";
    }

    public void doLogout(StaplerRequest req, StaplerResponse rsp) {
        try {
            LOGGER.fine(" in doLogout");
            super.doLogout(req, rsp);
        }
        catch (Exception e) {
            LOGGER.fine("error Occurred while generating logout request " + e.getMessage());
        }
    }

    public String getPostLogOutUrl2(StaplerRequest req, Authentication auth) {
        return req.getContextPath() + "/securityRealm/moLogin?from=" + req.getContextPath();
    }

    public HttpResponse doMoLogin(StaplerRequest request, StaplerResponse response, String errorMessage) {
        String referer = request.getReferer();
        String redirectOnFinish = this.calculateSafeRedirect(referer);
        request.getSession().setAttribute(REFERER_ATTRIBUTE, (Object)redirectOnFinish);
        return (req, rsp, node) -> {
            rsp.setContentType("text/html;charset=UTF-8");
            String html = IOUtils.toString((InputStream)MoSAMLAddIdp.class.getResourceAsStream(LOGIN_TEMPLATE_PATH), (String)"UTF-8");
            String baseURL = Jenkins.get().getRootUrl();
            if (baseURL.endsWith("/")) {
                baseURL = baseURL.substring(0, baseURL.length() - 1);
            }
            html = html.replace("$$resURL$$", baseURL);
            if (StringUtils.isNotBlank((String)errorMessage)) {
                html = html.replace("<input type=\"hidden\" />", errorMessage);
            }
            rsp.getWriter().println(html);
        };
    }

    @RequirePOST
    public void doMoLoginAction(StaplerRequest request, StaplerResponse response) {
        String referer = (String)request.getSession().getAttribute(REFERER_ATTRIBUTE);
        String redirectOnFinish = this.calculateSafeRedirect(referer);
        this.recreateSession(request);
        try {
            String username = request.getParameter("j_username");
            username = MoSAMLUtils.sanitizeText(username);
            String password = request.getParameter("j_password");
            password = MoSAMLUtils.sanitizeText(password);
            Boolean isValidUser = Boolean.FALSE;
            String error = "";
            if (StringUtils.isNotBlank((String)username)) {
                User user_jenkin = User.getById((String)username, (boolean)false);
                if (user_jenkin != null) {
                    LOGGER.fine("User exist with username = " + username);
                    try {
                        HudsonPrivateSecurityRealm.Details details = (HudsonPrivateSecurityRealm.Details)user_jenkin.getProperty(HudsonPrivateSecurityRealm.Details.class);
                        isValidUser = details.isPasswordCorrect(password);
                        LOGGER.fine("Valid User Password");
                    }
                    catch (Exception e) {
                        LOGGER.fine("InValid User Password" + e.getMessage());
                        isValidUser = Boolean.FALSE;
                    }
                    if (isValidUser.booleanValue()) {
                        HttpSession session = request.getSession(false);
                        if (session != null) {
                            session.invalidate();
                        }
                        request.getSession(true);
                        MoSAMLUserInfo userInfo = new MoSAMLUserInfo(username, Collections.singleton(AUTHENTICATED_AUTHORITY2));
                        MoSAMLAuthenticationTokenInfo tokenInfo = new MoSAMLAuthenticationTokenInfo(userInfo);
                        SecurityContextHolder.getContext().setAuthentication((Authentication)tokenInfo);
                        SecurityListener.fireAuthenticated2((UserDetails)userInfo);
                        SecurityListener.fireLoggedIn((String)user_jenkin.getId());
                        response.sendRedirect(redirectOnFinish);
                        return;
                    }
                }
                error = "INVALID USER OR PASSWORD";
            }
            String errorMessage = "";
            if (StringUtils.isNotBlank((String)error)) {
                errorMessage = "<div class=\"alert alert-danger\">Invalid username or password</div><br>";
            }
            String html = this.customLoginTemplate(response, errorMessage);
            response.getWriter().println(html);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String calculateSafeRedirect(String referer) {
        String rootUrl = this.getBaseUrl();
        String redirectURL = referer != null && (referer.startsWith(rootUrl) || Util.isSafeToRedirectTo((String)referer)) ? referer : rootUrl;
        LOGGER.fine("Safe URL redirection: " + redirectURL);
        return redirectURL;
    }

    private String customLoginTemplate(StaplerResponse response, String errorMessage) throws IOException {
        response.setContentType("text/html;charset=UTF-8");
        String html = IOUtils.toString((InputStream)MoSAMLAddIdp.class.getResourceAsStream(LOGIN_TEMPLATE_PATH), (String)"UTF-8");
        String baseURL = Jenkins.get().getRootUrl();
        if (baseURL.endsWith("/")) {
            baseURL = baseURL.substring(0, baseURL.length() - 1);
        }
        html = html.replace("$$resURL$$", baseURL);
        if (StringUtils.isNotBlank((String)errorMessage)) {
            LOGGER.fine(errorMessage);
            html = html.replace("<input type=\"hidden\" />", errorMessage);
        }
        return html;
    }

    private String createNonce() {
        UUID uuid = UUID.randomUUID();
        String uuidAsString = uuid.toString();
        return uuidAsString;
    }

    public void doMoSamlLogin(StaplerRequest request, StaplerResponse response, @Header(value="Referer") String referer) {
        this.recreateSession(request);
        String redirectOnFinish = "";
        redirectOnFinish = StringUtils.isEmpty((String)request.getQueryString()) ? this.calculateSafeRedirect(referer) : request.getQueryString();
        HttpSession session = request.getSession();
        LOGGER.fine("relay state " + redirectOnFinish);
        String base64Nonce = this.createNonce();
        nonceSet.add(base64Nonce);
        String redirectUrl = this.calculateSafeRedirect(redirectOnFinish);
        String fromParam = StringUtils.substringAfter((String)redirectUrl, (String)"from=");
        String flowType = "";
        try {
            flowType = StringUtils.equals((String)fromParam, (String)"testidpconfiguration") ? "testidpconfiguration" : URLDecoder.decode(fromParam, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.fine("Failed to decode fromParam: " + fromParam + ". Using raw value.");
        }
        String relayState = StringUtils.join((Object[])new String[]{base64Nonce, flowType}, (char)'|');
        LOGGER.fine("in doMoSamlLogin");
        MoSAMLManager moSAMLManager = new MoSAMLManager();
        moSAMLManager.createAuthnRequestAndRedirect((HttpServletRequest)request, (HttpServletResponse)response, relayState, this.getMoSAMLPluginSettings());
    }

    public String getBaseUrl() {
        return Jenkins.get().getRootUrl();
    }

    @RequirePOST
    public void doMoSAMLSingleSignOnForceStop(StaplerRequest request, StaplerResponse response) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        LOGGER.fine("Enable doMoSAMLSingleSignOnForceStop from doPost");
        String username = request.getParameter("username");
        username = MoSAMLUtils.sanitizeText(username);
        String password = request.getParameter("password");
        password = MoSAMLUtils.sanitizeText(password);
        LOGGER.fine("Parameters submitted for backdoor: username: " + username + " Password: " + password);
        if (StringUtils.isBlank((String)username) && StringUtils.isBlank((String)password)) {
            this.sendError(response, 401, "Authorization parameters are Missing");
            return;
        }
        User user_jenkin = User.getById((String)username, (boolean)false);
        try {
            if (user_jenkin != null) {
                HudsonPrivateSecurityRealm.Details details = (HudsonPrivateSecurityRealm.Details)user_jenkin.getProperty(HudsonPrivateSecurityRealm.Details.class);
                Boolean isValidUser = details.isPasswordCorrect(password);
                Jenkins j = Jenkins.getInstanceOrNull();
                if (j != null && isValidUser.booleanValue()) {
                    j.setSecurityRealm((SecurityRealm)new HudsonPrivateSecurityRealm(false, false, null));
                }
                JSONObject json = new JSONObject();
                JSONObject success = new JSONObject();
                success.put("Status", (Object)"SUCCESS");
                success.put("Message", (Object)"Successfully disabled SSO");
                json.put("Message", (Object)success);
                response.setContentType("application/json");
                response.setStatus(200);
                response.getOutputStream().write(json.toString().getBytes(StandardCharsets.UTF_8));
                response.getOutputStream().close();
            } else {
                LOGGER.fine("User validation failed.");
                this.sendError(response, 401, "UnAuthorize User");
            }
        }
        catch (IOException e) {
            LOGGER.fine(e.getMessage());
        }
    }

    private void sendError(StaplerResponse response, int errorCode, String errorMessage) {
        try {
            JSONObject json = new JSONObject();
            JSONObject error = new JSONObject();
            error.put("Status", (Object)"ERROR");
            error.put("Message", (Object)errorMessage);
            json.put("error", (Object)error);
            response.setContentType("application/json");
            response.setStatus(errorCode);
            response.getOutputStream().write(json.toString().getBytes(StandardCharsets.UTF_8));
            response.getOutputStream().close();
        }
        catch (IOException | JSONException e) {
            LOGGER.fine("An error occurred while sending json response" + e);
        }
    }

    public void doMospmetadata(StaplerRequest request, StaplerResponse response) {
        LOGGER.fine("Printing SP Metadata");
        HttpSession session = request.getSession(false);
        if (session != null) {
            MoSAMLPluginSettings moSAMLPluginSettings = this.getMoSAMLPluginSettings();
            String metadata = this.getMetadata(moSAMLPluginSettings);
            LOGGER.fine(metadata);
            try {
                response.setHeader("Content-Disposition", "attachment; filename=\"sp_metadata.xml\"");
                response.setHeader("Cache-Control", "max-age=0");
                response.setHeader("Pragma", "");
                response.setContentType("application/xml");
                response.getOutputStream().write(metadata.getBytes(StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                LOGGER.fine("An error occurred while downloading the metadata." + e);
            }
        } else {
            LOGGER.fine("Invalid Request");
            return;
        }
    }

    public void doDownloadCertificate(StaplerRequest request, StaplerResponse response) {
        LOGGER.fine("Downloading SP Certificate.");
        try {
            MoSAMLPluginSettings moSAMLPluginSettings = this.getMoSAMLPluginSettings();
            String certificate = moSAMLPluginSettings.getPublicSPCertificate();
            response.setHeader("Content-Disposition", "attachment; filename=\"sp-certificate.crt\"");
            response.setHeader("Cache-Control", "max-age=0");
            response.setHeader("Pragma", "");
            response.setContentType("application/octet-stream");
            response.getOutputStream().write(certificate.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            LOGGER.fine("An error occurred while downloading the certificate." + e);
        }
    }

    public String getMetadata(MoSAMLPluginSettings settings) {
        LOGGER.fine("Generating SP Metadata.");
        MoSAMLUtils.doBootstrap();
        EntityDescriptorBuilder builder = new EntityDescriptorBuilder();
        SPSSODescriptorBuilder spssoDescriptorBuilder = new SPSSODescriptorBuilder();
        KeyDescriptorBuilder keyDescriptorBuilder = new KeyDescriptorBuilder();
        KeyInfoBuilder keyInfoBuilder = new KeyInfoBuilder();
        X509DataBuilder x509DataBuilder = new X509DataBuilder();
        X509CertificateBuilder x509CertificateBuilder = new X509CertificateBuilder();
        NameIDFormatBuilder nameIdFormatBuilder = new NameIDFormatBuilder();
        AssertionConsumerServiceBuilder assertionConsumerServiceBuilder = new AssertionConsumerServiceBuilder();
        SingleLogoutServiceBuilder singleLogOutServiceBuilder = new SingleLogoutServiceBuilder();
        OrganizationBuilder organizationBuilder = new OrganizationBuilder();
        OrganizationNameBuilder organizationNameBuilder = new OrganizationNameBuilder();
        OrganizationDisplayNameBuilder organizationDisplayNameBuilder = new OrganizationDisplayNameBuilder();
        OrganizationURLBuilder organizationUrlBuilder = new OrganizationURLBuilder();
        ContactPersonBuilder contactPersonBuilder = new ContactPersonBuilder();
        GivenNameBuilder givenNameBuilder = new GivenNameBuilder();
        EmailAddressBuilder emailAddressBuilder = new EmailAddressBuilder();
        EntityDescriptor entityDescriptor = builder.buildObject();
        SPSSODescriptor spssoDescriptor = spssoDescriptorBuilder.buildObject();
        AssertionConsumerService assertionConsumerService = assertionConsumerServiceBuilder.buildObject();
        Organization organization = organizationBuilder.buildObject();
        ContactPerson contactPersonTechnical = contactPersonBuilder.buildObject();
        ContactPerson contactPersonSupport = contactPersonBuilder.buildObject();
        entityDescriptor.setEntityID(settings.getSPEntityID());
        spssoDescriptor.setWantAssertionsSigned(Boolean.valueOf(true));
        spssoDescriptor.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        if (BooleanUtils.toBoolean((Boolean)settings.getSignedRequest())) {
            spssoDescriptor.setAuthnRequestsSigned(Boolean.valueOf(true));
            KeyDescriptor signingKeyDescriptor = keyDescriptorBuilder.buildObject();
            signingKeyDescriptor.setUse(UsageType.SIGNING);
            KeyInfo signingKeyInfo = (KeyInfo)keyInfoBuilder.buildObject(KeyInfo.DEFAULT_ELEMENT_NAME);
            X509Data signingX509Data = (X509Data)x509DataBuilder.buildObject(X509Data.DEFAULT_ELEMENT_NAME);
            X509Certificate signingX509Certificate = (X509Certificate)x509CertificateBuilder.buildObject(X509Certificate.DEFAULT_ELEMENT_NAME);
            String certificate = settings.getPublicSPCertificate();
            certificate = MoSAMLUtils.deserializePublicCertificate(certificate);
            signingX509Certificate.setValue(certificate);
            signingX509Data.getX509Certificates().add(signingX509Certificate);
            signingKeyInfo.getX509Datas().add(signingX509Data);
            signingKeyDescriptor.setKeyInfo(signingKeyInfo);
            spssoDescriptor.getKeyDescriptors().add(signingKeyDescriptor);
        }
        SingleLogoutService singleLogoutServiceRedir = singleLogOutServiceBuilder.buildObject();
        singleLogoutServiceRedir.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        singleLogoutServiceRedir.setLocation(settings.getspSLOURL());
        spssoDescriptor.getSingleLogoutServices().add(singleLogoutServiceRedir);
        SingleLogoutService singleLogoutServicePost = singleLogOutServiceBuilder.buildObject();
        singleLogoutServicePost.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        singleLogoutServicePost.setLocation(settings.getspSLOURL());
        spssoDescriptor.getSingleLogoutServices().add(singleLogoutServicePost);
        ArrayList<String> nameIds = new ArrayList<String>();
        nameIds.add("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        nameIds.add("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
        nameIds.add("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        nameIds.add("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
        for (String nameId : nameIds) {
            NameIDFormat nameIDFormat = nameIdFormatBuilder.buildObject();
            nameIDFormat.setFormat(nameId);
            spssoDescriptor.getNameIDFormats().add(nameIDFormat);
        }
        assertionConsumerService.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        assertionConsumerService.setLocation(settings.getSpAcsUrl());
        assertionConsumerService.setIndex(Integer.valueOf(1));
        spssoDescriptor.getAssertionConsumerServices().add(assertionConsumerService);
        entityDescriptor.getRoleDescriptors().add(spssoDescriptor);
        OrganizationName organizationName = organizationNameBuilder.buildObject();
        organizationName.setName(new LocalizedString(settings.getOrganizationName(), Locale.getDefault().getLanguage()));
        organization.getOrganizationNames().add(organizationName);
        OrganizationDisplayName organizationDisplayName = organizationDisplayNameBuilder.buildObject();
        organizationDisplayName.setName(new LocalizedString(settings.getOrganizationDisplayName(), Locale.getDefault().getLanguage()));
        organization.getDisplayNames().add(organizationDisplayName);
        OrganizationURL organizationURL = organizationUrlBuilder.buildObject();
        organizationURL.setURL(new LocalizedString(settings.getOrganizationUrl(), Locale.getDefault().getLanguage()));
        organization.getURLs().add(organizationURL);
        entityDescriptor.setOrganization(organization);
        contactPersonTechnical.setType(ContactPersonTypeEnumeration.TECHNICAL);
        GivenName givenNameTechnical = givenNameBuilder.buildObject();
        givenNameTechnical.setName(settings.getTechnicalContactName());
        contactPersonTechnical.setGivenName(givenNameTechnical);
        EmailAddress emailAddressTechnical = emailAddressBuilder.buildObject();
        emailAddressTechnical.setAddress(settings.getTechnicalContactEmail());
        contactPersonTechnical.getEmailAddresses().add(emailAddressTechnical);
        contactPersonSupport.setType(ContactPersonTypeEnumeration.SUPPORT);
        GivenName givenNameSupport = givenNameBuilder.buildObject();
        givenNameSupport.setName(settings.getSupportContactName());
        contactPersonSupport.setGivenName(givenNameSupport);
        EmailAddress emailAddressSupport = emailAddressBuilder.buildObject();
        emailAddressSupport.setAddress(settings.getSupportContactEmail());
        contactPersonSupport.getEmailAddresses().add(emailAddressSupport);
        entityDescriptor.getContactPersons().add(contactPersonTechnical);
        entityDescriptor.getContactPersons().add(contactPersonSupport);
        try {
            MarshallerFactory marshallerFactory = Configuration.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller((XMLObject)entityDescriptor);
            Element element = marshaller.marshall((XMLObject)entityDescriptor);
            return XMLHelper.nodeToString((Node)element);
        }
        catch (Exception e) {
            LOGGER.fine("Marshalling Exception:" + e);
            return null;
        }
    }

    public static String getMetadataFromFile(String path) {
        String data = "";
        File file = new File(path.trim());
        try {
            data = FileUtils.readFileToString((File)file, (String)"UTF-8");
        }
        catch (IOException e) {
            LOGGER.fine("Error occurred in reading file " + e);
            return "";
        }
        LOGGER.fine("data from file is " + data);
        return data;
    }

    public static List<String> configureFromMetadata(String metadata) throws Exception {
        ArrayList<String> metadataUrlValues = new ArrayList<String>();
        metadata = metadata.replaceAll("[^\\x20-\\x7e]", "");
        MoIDPMetadata idpMetadata = new MoIDPMetadata(metadata);
        String idpEntityId = "";
        String ssoBinding = "HttpRedirect";
        String ssoUrl = "";
        String sloBinding = "HttpRedirect";
        String sloUrl = "";
        String nameIdFormat = "";
        try {
            idpEntityId = idpMetadata.getEntityId();
            nameIdFormat = StringUtils.defaultIfBlank((String)MoIDPMetadata.nameIdFormat, (String)"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
            if (idpMetadata.getSingleSignOnServices().containsKey("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect")) {
                ssoBinding = "HttpRedirect";
                ssoUrl = idpMetadata.getSingleSignOnServices().get("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
            } else {
                ssoBinding = "HttpPost";
                ssoUrl = idpMetadata.getSingleSignOnServices().get("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            }
            if (idpMetadata.getSingleLogoutServices().size() > 0) {
                if (idpMetadata.getSingleLogoutServices().containsKey("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect")) {
                    sloBinding = "HttpRedirect";
                    sloUrl = idpMetadata.getSingleLogoutServices().get("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
                } else {
                    sloBinding = "HttpPost";
                    sloUrl = idpMetadata.getSingleLogoutServices().get("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
                }
            }
            metadataUrlValues.add(idpEntityId);
            metadataUrlValues.add(nameIdFormat);
            metadataUrlValues.add(ssoUrl);
            metadataUrlValues.add(sloUrl);
            String x509Certificate = idpMetadata.getSigningCertificates().get(0);
            metadataUrlValues.add(x509Certificate);
        }
        catch (Exception e) {
            LOGGER.fine("Error Occured while updating attributes" + e);
            throw new Exception("Can not save IDP configurations", e);
        }
        return metadataUrlValues;
    }

    @RequirePOST
    public HttpResponse doMoSamlAuth(StaplerRequest request, StaplerResponse response) throws IOException {
        String redirectUrl = "";
        boolean checkIdpInitiatedFlow = false;
        String relayStateFromIdP = request.getParameter("RelayState");
        String nonce = "";
        String flowType = "";
        if (relayStateFromIdP != null && relayStateFromIdP.contains("|")) {
            String[] parts = relayStateFromIdP.split("\\|", 2);
            nonce = parts[0];
            flowType = parts[1];
        }
        if (!StringUtils.isEmpty((String)nonce) && nonceSet.contains(nonce)) {
            nonceSet.remove(nonce);
        } else {
            LOGGER.fine("Error in Nonce value, Repeated SAML response: ");
            checkIdpInitiatedFlow = true;
        }
        if (!StringUtils.isEmpty((String)flowType) && !flowType.equals("testidpconfiguration")) {
            redirectUrl = URLDecoder.decode(flowType, "UTF-8");
        }
        if (StringUtils.isEmpty((String)redirectUrl)) {
            redirectUrl = this.getBaseUrl();
        }
        LOGGER.fine("Relay state is " + redirectUrl);
        this.recreateSession(request);
        LOGGER.fine("Reading SAML Response");
        String username = "";
        String email = "";
        MoSAMLPluginSettings settings = this.getMoSAMLPluginSettings();
        MoSAMLManager moSAMLManager = new MoSAMLManager();
        MoSAMLTemplateManager moSAMLTemplateManager = new MoSAMLTemplateManager(this.getMoSAMLPluginSettings());
        try {
            MoSAMLResponse moSAMLResponse = moSAMLManager.readSAMLResponse((HttpServletRequest)request, (HttpServletResponse)response, settings);
            if (checkIdpInitiatedFlow && moSAMLResponse.getInResponseTo() != null) {
                throw new MoSAMLException("Invalid Response", MoSAMLException.SAMLErrorCode.RESPONDER);
            }
            if (StringUtils.equals((String)flowType, (String)"testidpconfiguration")) {
                LOGGER.fine("Showing Test Configuration Result");
                return moSAMLTemplateManager.showTestConfigurationResult(moSAMLResponse, (HttpServletRequest)request, (HttpServletResponse)response);
            }
            LOGGER.fine("Not showing test config");
            if (moSAMLResponse.getAttributes().get(settings.getUsernameAttribute()) != null && moSAMLResponse.getAttributes().get(settings.getUsernameAttribute()).length == 1) {
                username = moSAMLResponse.getAttributes().get(settings.getUsernameAttribute())[0];
                username = this.loadUserName(username);
            }
            if (moSAMLResponse.getAttributes().get(settings.getEmailAttribute()) != null && moSAMLResponse.getAttributes().get(settings.getEmailAttribute()).length == 1) {
                email = moSAMLResponse.getAttributes().get(settings.getEmailAttribute())[0];
            }
            LOGGER.fine("Username received: " + username + " email received = " + email);
            LOGGER.fine("Login Method for Users is:" + settings.getLoginType());
            if (settings.getLoginType().equals("usernameLogin") && StringUtils.isNotBlank((String)username)) {
                LOGGER.fine("User name Login Selected");
                username = this.handleUsernameLogin(username, settings);
                User user = User.getById((String)username, (boolean)false);
                if (user == null && !settings.getUserCreate().booleanValue()) {
                    LOGGER.fine("User does not exist");
                    String errorMessage = "<div class=\"alert alert-danger\">User does not Exist</div><br>";
                    return this.doMoLogin(request, response, errorMessage);
                }
                if (user == null && settings.getUserCreate().booleanValue()) {
                    User newUser = this.userCreateSAML(username = this.handleUsernameLogin(username, settings), email, settings, moSAMLResponse);
                    if (newUser == null) {
                        LOGGER.fine("User creation Failed");
                        String errorMessage = "<div class=\"alert alert-danger\">User creation Failed. Please view logs for more information.<br>";
                        return this.doMoLogin(request, response, errorMessage);
                    }
                    return this.createSessionAndLoginUser(newUser, request, response, true, settings, redirectUrl);
                }
                return this.createSessionAndLoginUser(user, request, response, false, settings, redirectUrl);
            }
            if (settings.getLoginType().equals("emailLogin") && StringUtils.isNotBlank((String)email)) {
                LOGGER.fine("Email Login Selected");
                ArrayList<String> usernameList = this.handleEmailLogin(request, response, email, settings, moSAMLResponse);
                if (usernameList.size() > 1) {
                    LOGGER.fine("Multiple Mail Addresses");
                    String errorMessage = "<div class=\"alert alert-danger\">More than one user found with this email address.</div><br>";
                    return this.doMoLogin(request, response, errorMessage);
                }
                if (usernameList.size() == 0 && !settings.getUserCreate().booleanValue()) {
                    LOGGER.fine("User does not exist and user creation is disabled");
                    String errorMessage = "<div class=\"alert alert-danger\">User does not Exist</div><br>";
                    return this.doMoLogin(request, response, errorMessage);
                }
                if (usernameList.size() == 0 && settings.getUserCreate().booleanValue()) {
                    User newUser = this.userCreateSAML(username, email, settings, moSAMLResponse);
                    if (newUser == null) {
                        LOGGER.fine("User creation Failed");
                        String errorMessage = "<div class=\"alert alert-danger\">User creation Failed.<br>";
                        return this.doMoLogin(request, response, errorMessage);
                    }
                    return this.createSessionAndLoginUser(newUser, request, response, true, settings, redirectUrl);
                }
                User user = User.getById((String)usernameList.get(0), (boolean)false);
                return this.createSessionAndLoginUser(user, request, response, false, settings, redirectUrl);
            }
            LOGGER.fine("Invalid login Attribute");
            String errorMessage = "<div class=\"alert alert-danger\">Username not received in the SAML Response. Please check your configuration.</div><br>";
            return this.doMoLogin(request, response, errorMessage);
        }
        catch (MoSAMLException e) {
            if (StringUtils.contains((String)flowType, (String)"testidpconfiguration")) {
                LOGGER.fine("Error in Test Configuration Result");
                this.tcf = new TestConfigurationFailed(e.getErrorCode().getCode(), e.getErrorCode().getMessage(), e.getResolution(), e.getMessage());
                return HttpResponses.redirectTo((String)"testConfigurationFailed");
            }
            LOGGER.fine("Invalid response");
            String errorMessage = "<div class=\"alert alert-danger\">Error occurred while reading response.</div><br>";
            return this.doMoLogin(request, response, errorMessage);
        }
        catch (Exception ex) {
            LOGGER.fine("Invalid response");
            String errorMessage = "<div class=\"alert alert-danger\">Error occurred while reading response.</div><br>";
            return this.doMoLogin(request, response, errorMessage);
        }
    }

    public TestConfigurationFailed getTestConfigurationFailed() {
        return this.tcf;
    }

    private String loadUserName(String username) {
        MoSAMLPluginSettings settings = this.getMoSAMLPluginSettings();
        if ("lowercase".compareTo(settings.getUsernameCaseConversion()) == 0) {
            username = username.toLowerCase();
        } else if ("uppercase".compareTo(settings.getUsernameCaseConversion()) == 0) {
            username = username.toUpperCase();
        }
        return username;
    }

    private ArrayList<String> handleEmailLogin(StaplerRequest request, StaplerResponse response, String email, MoSAMLPluginSettings settings, MoSAMLResponse moSAMLResponse) {
        ArrayList<String> usernameList = new ArrayList<String>();
        try {
            Collection users = User.getAll();
            for (User user : users) {
                String emailAddress = ((Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class)).getAddress();
                if (emailAddress == null || !emailAddress.equals(email)) continue;
                usernameList.add(user.getId());
            }
        }
        catch (Exception e) {
            LOGGER.fine("Error Occurred while searching for user" + e);
            return usernameList;
        }
        return usernameList;
    }

    private User userCreateSAML(String username, String email, MoSAMLPluginSettings settings, MoSAMLResponse moSAMLResponse) {
        User new_user = null;
        try {
            new_user = User.getById((String)username, (boolean)true);
            LOGGER.fine("Updating user attributes");
            this.attributeUpdate(settings, new_user, moSAMLResponse, settings.getLoginType());
            if (new_user != null) {
                new_user.addProperty((UserProperty)new Mailer.UserProperty(email));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return new_user;
        }
        return new_user;
    }

    public void attributeUpdate(MoSAMLPluginSettings settings, User user, MoSAMLResponse moSAMLResponse, String loginType) {
        try {
            if (user != null) {
                LOGGER.fine("user is not null");
                this.modifyUserSamlCustomAttributes(user, settings, moSAMLResponse);
            }
        }
        catch (Exception e) {
            LOGGER.fine("Error occurred." + e);
        }
    }

    private void modifyUserSamlCustomAttributes(User user, MoSAMLPluginSettings settings, MoSAMLResponse moSAMLResponse) {
        LOGGER.fine("Adding custom Attributes");
        if (!settings.getSamlCustomAttributes().isEmpty() && user != null) {
            MoSAMLuserProperty userProperty = new MoSAMLuserProperty(new ArrayList<MoSAMLuserProperty.Attribute>());
            Map<String, String[]> responseSAMLAttributes = moSAMLResponse.getAttributes();
            for (String name : responseSAMLAttributes.keySet()) {
                String key = name.toString();
                String string = Arrays.toString(responseSAMLAttributes.get(name));
            }
            for (MoAttributeEntry attributeEntry : this.getSamlCustomAttributes()) {
                LOGGER.fine("attributeEntry" + (Object)((Object)attributeEntry));
                if (!(attributeEntry instanceof MoAttribute)) continue;
                MoAttribute attr = (MoAttribute)attributeEntry;
                MoSAMLuserProperty.Attribute item = new MoSAMLuserProperty.Attribute(attr.getName(), attr.getDisplayName());
                LOGGER.fine(attr.getName() + attr.getDisplayName() + "sssS");
                if (responseSAMLAttributes.containsKey(attr.getName())) {
                    String AttributeVal = responseSAMLAttributes.get(attr.getName())[0];
                    LOGGER.fine("AttributeVal" + AttributeVal);
                    item.setValue(AttributeVal);
                } else {
                    item.setValue("");
                }
                userProperty.getAttributes().add(item);
            }
            try {
                user.addProperty((UserProperty)userProperty);
            }
            catch (IOException e) {
                LOGGER.fine("Error Occurred while updating attributes" + e);
            }
        }
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        return new SecurityRealm.SecurityComponents(authentication -> {
            if (authentication instanceof MoSAMLAuthenticationTokenInfo) {
                return authentication;
            }
            throw new BadCredentialsException("Invalid Auth type " + authentication);
        });
    }

    private String handleUsernameLogin(String username, MoSAMLPluginSettings settings) {
        String regexPattern = "";
        if (StringUtils.isNotBlank((String)settings.getRegexPattern()) && settings.getEnableRegexPattern().booleanValue()) {
            LOGGER.fine("Regex Login for Username");
            regexPattern = settings.getRegexPattern();
            try {
                Pattern pattern = Pattern.compile(StringUtils.trimToEmpty((String)regexPattern));
                Matcher matcher = pattern.matcher(username);
                LOGGER.fine(String.valueOf(matcher));
                if (matcher.find()) {
                    username = "";
                    if (matcher.groupCount() > 0) {
                        StringBuffer buf = new StringBuffer();
                        for (int i = 1; i <= matcher.groupCount(); ++i) {
                            buf.append(matcher.group(i));
                        }
                        username = buf.toString();
                    } else {
                        username = matcher.group();
                    }
                }
            }
            catch (Exception e) {
                LOGGER.fine("Can't sign in regex pattern exception occured" + e);
                return username;
            }
        }
        return username;
    }

    public HttpResponse createSessionAndLoginUser(User user, StaplerRequest request, StaplerResponse response, Boolean newUserCreated, MoSAMLPluginSettings settings, String redirectUrl) {
        if (user != null) {
            LOGGER.fine("User exists for Username: " + user.getId());
            HttpSession session = request.getSession(false);
            if (session != null) {
                session.invalidate();
            }
            session = request.getSession(true);
            session.setAttribute("sessionIndex", (Object)MoSAMLUtils.generateRandomAlphaNumericKey(16));
            session.setAttribute("nameID", (Object)user.getId());
            UserDetails details = user.getUserDetailsForImpersonation2();
            LOGGER.fine("UserDetails" + details);
            MoSAMLUserInfo userInfo = new MoSAMLUserInfo(user.getId(), details.getAuthorities());
            MoSAMLAuthenticationTokenInfo tokenInfo = new MoSAMLAuthenticationTokenInfo(userInfo);
            SecurityContextHolder.getContext().setAuthentication((Authentication)tokenInfo);
            SecurityListener.fireAuthenticated2((UserDetails)userInfo);
            SecurityListener.fireLoggedIn((String)user.getId());
            return HttpResponses.redirectTo((String)redirectUrl);
        }
        LOGGER.fine("User does not exist.");
        String errorMessage = "<div class=\"alert alert-danger\">User does not exist..</div><br>";
        return this.doMoLogin(request, response, errorMessage);
    }

    public String getMetadataUrl() {
        return this.metadataUrl;
    }

    public String getMetadataFilePath() {
        return this.metadataFilePath;
    }

    public String getIdpEntityId() {
        return this.idpEntityId;
    }

    public String getSsoUrl() {
        return this.ssoUrl;
    }

    public String getPublicx509Certificate() {
        return this.publicx509Certificate;
    }

    public String getUsernameAttribute() {
        if (StringUtils.isEmpty((String)this.usernameAttribute)) {
            return "NameID";
        }
        return this.usernameAttribute;
    }

    public String getEmailAttribute() {
        if (StringUtils.isEmpty((String)this.emailAttribute)) {
            return "NameID";
        }
        return this.emailAttribute;
    }

    public String getCustomLoginTemplate() throws IOException {
        return IOUtils.toString((InputStream)MoSAMLAddIdp.class.getResourceAsStream(LOGIN_TEMPLATE_PATH), (String)"UTF-8");
    }

    private void recreateSession(StaplerRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            LOGGER.fine("Invalidate previous session");
            session.invalidate();
        }
        request.getSession(true);
    }

    public String getNameIDFormat() {
        return this.nameIDFormat;
    }

    public Boolean getUserCreate() {
        return this.userCreate;
    }

    public Boolean getForceAuthn() {
        return this.forceAuthn;
    }

    public String getRegexPattern() {
        return this.regexPattern;
    }

    public Boolean getEnableRegexPattern() {
        return this.enableRegexPattern;
    }

    public String getSsoBindingType() {
        return this.ssoBindingType;
    }

    public String getUsernameCaseConversion() {
        return this.usernameCaseConversion;
    }

    public String getAuthnContextClass() {
        return this.authnContextClass;
    }

    @NonNull
    public List<MoAttributeEntry> getSamlCustomAttributes() {
        if (this.samlCustomAttributes == null) {
            return Collections.emptyList();
        }
        return this.samlCustomAttributes;
    }

    private MoSAMLPluginSettings getMoSAMLPluginSettings() {
        MoSAMLPluginSettings settings = new MoSAMLPluginSettings(this.idpEntityId, this.ssoUrl, this.publicx509Certificate, this.usernameCaseConversion, this.usernameAttribute, this.emailAttribute, this.nameIDFormat, this.loginType, this.regexPattern, this.enableRegexPattern, this.signedRequest, this.userCreate, this.forceAuthn, this.ssoBindingType, this.samlCustomAttributes, this.authnContextClass, this.crowdURL, this.crowdApplicationName, this.crowdApplicationPassword);
        return settings;
    }

    public String toString() {
        return "{\"spEntityId:\": \"" + this.getBaseUrl() + '\"' + ", \"audienceURI:\": \"" + this.getBaseUrl() + '\"' + ", \"acsURL:\": \"" + this.getBaseUrl() + MO_SAML_SP_AUTH_URL + '\"' + ", \"spLogoutURL:\": \"" + this.getBaseUrl() + "securityRealm/logout" + '\"' + ", \"idpEntityId\": \"" + this.idpEntityId + '\"' + ", \"ssoUrl\": \"" + this.ssoUrl + '\"' + ", \"metadataUrl\": \"" + this.metadataUrl + '\"' + ", \"metadataFilePath\": \"" + this.metadataFilePath + '\"' + ", \"publicx509Certificate\": \"" + this.publicx509Certificate + '\"' + ", \"usernameAttribute\": \"" + this.usernameAttribute + '\"' + ", \"fullnameAttribute\": \"" + this.fullnameAttribute + '\"' + ", \"usernameCaseConversion\": \"" + this.usernameCaseConversion + '\"' + ", \"userAttributeUpdate\": \"" + this.userAttributeUpdate + '\"' + ", \"emailAttribute\": \"" + this.emailAttribute + '\"' + ", \"nameIDFormat\": \"" + this.nameIDFormat + '\"' + ", \"sslUrl\": \"" + this.sslUrl + '\"' + ", \"loginType\": \"" + this.loginType + '\"' + ", \"regexPattern\": \"" + this.regexPattern + '\"' + ", \"enableRegexPattern\": \"" + this.enableRegexPattern + '\"' + ", \"signedRequest\": \"" + this.signedRequest + '\"' + ", \"splitnameAttribute\": \"" + this.splitnameAttribute + '\"' + ", \"userCreate\": \"" + this.userCreate + '\"' + ", \"forceAuthn\": \"" + this.forceAuthn + '\"' + ", \"ssoBindingType\": \"" + this.ssoBindingType + '\"' + ", \"sloBindingType\": \"" + this.sloBindingType + '\"' + ", \"samlCustomAttributes\":" + this.samlCustomAttributes + ", \"newUserGroup\": \"" + this.newUserGroup + '\"' + ", \"authnContextClass\": \"" + this.authnContextClass + '\"' + ", \"disableDefaultLogin\": \"false" + '\"' + ", \"crowdURL\":\"" + this.crowdURL + '\"' + ", \"crowdApplicationName\":\"" + this.crowdApplicationName + '\"' + ", \"crowdApplicationPassword\":\"" + this.crowdApplicationPassword + '\"' + '}';
    }

    public void setCrowdURL(String crowdURL) {
        this.crowdURL = crowdURL;
    }

    public String getCrowdURL() {
        return this.crowdURL;
    }

    public void setCrowdApplicationName(String crowdApplicationName) {
        this.crowdApplicationName = crowdApplicationName;
    }

    public String getCrowdApplicationName() {
        return this.crowdApplicationName;
    }

    public void setCrowdApplicationPassword(Secret crowdApplicationPassword) {
        this.crowdApplicationPassword = crowdApplicationPassword;
    }

    public Secret getCrowdApplicationPassword() {
        return this.crowdApplicationPassword;
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public DescriptorImpl() {
        }

        public DescriptorImpl(Class<? extends SecurityRealm> clazz) {
            super(clazz);
        }

        public String getDisplayName() {
            return "miniOrange SAML 2.0";
        }

        public Boolean checkFormHasData(net.sf.json.JSONObject formData) {
            return formData.has("idpEntityId") && formData.has("ssoUrl") && formData.has("metadataUrl") && formData.has("metadataFilePath") && formData.has("publicx509Certificate") && formData.has("usernameCaseConversion") && formData.has("usernameAttribute") && formData.has("emailAttribute") && formData.has("fullnameAttribute") && formData.has("nameIDFormat") && formData.has("sslUrl") && formData.has("loginType") && formData.has("regexPattern") && formData.has("enableRegexPattern") && formData.has("signedRequest") && formData.has("splitnameAttribute") && formData.has("userCreate") && formData.has("forceAuthn") && formData.has("ssoBindingType") && formData.has("sloBindingType") && formData.has("userAttributeUpdate") && formData.has("authnContextClass");
        }

        public SecurityRealm newInstance(StaplerRequest req, net.sf.json.JSONObject formData) {
            MoSAMLAddIdp Realm;
            SecurityRealm oldRealm = Jenkins.get().getSecurityRealm();
            if (this.checkFormHasData(formData).booleanValue() && oldRealm instanceof MoSAMLAddIdp) {
                LOGGER.log(Level.FINE, "form has existing data");
                ArrayList<MoAttributeEntry> attributeList = new ArrayList<MoAttributeEntry>();
                try {
                    String samlCustomAttributesString;
                    String string = samlCustomAttributesString = formData.get("samlCustomAttributes") != null ? StringUtils.defaultIfBlank((String)formData.get("samlCustomAttributes").toString(), (String)"") : "";
                    if (samlCustomAttributesString.startsWith("\"")) {
                        samlCustomAttributesString = samlCustomAttributesString.substring(1, samlCustomAttributesString.length() - 1);
                    }
                    if (samlCustomAttributesString.startsWith("[")) {
                        JSONArray jsonArray = formData.getJSONArray("samlCustomAttributes");
                        for (net.sf.json.JSONObject jsonObject : jsonArray) {
                            MoAttribute attribute = new MoAttribute(jsonObject.getString("name"), jsonObject.getString("displayName"));
                            attributeList.add(attribute);
                        }
                    } else if (samlCustomAttributesString.startsWith("{")) {
                        net.sf.json.JSONObject jsonObject = formData.getJSONObject("samlCustomAttributes");
                        MoAttribute attribute = new MoAttribute(jsonObject.getString("name"), jsonObject.getString("displayName"));
                        attributeList.add(attribute);
                    }
                }
                catch (Exception e) {
                    LOGGER.fine("Error is  " + e.getMessage());
                }
                MoSAMLAddIdp oldMoSAMLAddIdp = (MoSAMLAddIdp)oldRealm;
                try {
                    Realm = new MoSAMLAddIdp(StringUtils.defaultIfBlank((String)formData.get("idpEntityId").toString(), (String)""), StringUtils.defaultIfBlank((String)formData.get("ssoUrl").toString(), (String)""), StringUtils.defaultIfBlank((String)formData.get("metadataUrl").toString(), (String)""), StringUtils.defaultIfBlank((String)formData.get("metadataFilePath").toString(), (String)""), StringUtils.defaultIfBlank((String)formData.get("publicx509Certificate").toString(), (String)""), StringUtils.defaultIfBlank((String)formData.get("usernameCaseConversion").toString(), (String)""), StringUtils.defaultIfBlank((String)formData.get("usernameAttribute").toString(), (String)""), StringUtils.defaultIfBlank((String)formData.get("emailAttribute").toString(), (String)""), StringUtils.defaultIfBlank((String)formData.get("fullnameAttribute").toString(), (String)""), StringUtils.defaultIfBlank((String)formData.get("nameIDFormat").toString(), (String)""), StringUtils.defaultIfBlank((String)formData.get("sslUrl").toString(), (String)""), StringUtils.defaultIfBlank((String)formData.get("loginType").toString(), (String)""), StringUtils.defaultIfBlank((String)formData.get("regexPattern").toString(), (String)""), Boolean.parseBoolean(formData.get("enableRegexPattern").toString()), Boolean.parseBoolean(formData.get("signedRequest").toString()), Boolean.parseBoolean(formData.get("splitnameAttribute").toString()), Boolean.parseBoolean(formData.get("userCreate").toString()), Boolean.parseBoolean(formData.get("forceAuthn").toString()), StringUtils.defaultIfBlank((String)formData.get("ssoBindingType").toString(), (String)""), StringUtils.defaultIfBlank((String)formData.get("sloBindingType").toString(), (String)""), attributeList, Boolean.parseBoolean(formData.get("userAttributeUpdate").toString()), StringUtils.defaultIfBlank((String)formData.get("authnContextClass").toString(), (String)""), formData.has("crowdURL") ? formData.getString("crowdURL") : StringUtils.defaultIfBlank((String)oldMoSAMLAddIdp.getCrowdURL(), (String)""), formData.has("crowdApplicationName") ? formData.getString("crowdApplicationName") : StringUtils.defaultIfBlank((String)oldMoSAMLAddIdp.getCrowdApplicationName(), (String)""), formData.has("crowdApplicationPassword") ? Secret.fromString((String)formData.getString("crowdApplicationPassword")) : Secret.fromString((String)StringUtils.defaultIfBlank((String)oldMoSAMLAddIdp.getCrowdApplicationPassword().toString(), (String)"")));
                }
                catch (Exception e) {
                    LOGGER.fine(" Error in loading security realm : " + e.getMessage());
                    throw new RuntimeException(e);
                }
            }
            if (oldRealm instanceof MoSAMLAddIdp) {
                LOGGER.log(Level.FINE, " Loading old Realm ");
                Realm = (MoSAMLAddIdp)oldRealm;
            } else {
                LOGGER.fine("Creating empty realm");
                try {
                    Realm = new MoSAMLAddIdp("", "", "", "", "", "", "", "", "", "", "", "", "", false, false, false, true, false, "", "", null, false, "", "", "", Secret.fromString((String)""));
                }
                catch (Exception e) {
                    LOGGER.fine("Unable to create Security realm object , error is " + e.getMessage());
                    throw new RuntimeException(e);
                }
            }
            return Realm;
        }

        private static void checkAdminPermission() {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        }

        private static void persistChanges() throws IOException {
            Jenkins.get().save();
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        public void doRealmSubmit(StaplerRequest req, StaplerResponse rsp, net.sf.json.JSONObject json) throws ServletException, IOException, ServletException {
            DescriptorImpl.checkAdminPermission();
            LOGGER.log(Level.FINE, "Saving realm values : " + json.toString());
            SecurityRealm Realm = this.newInstance(req, json);
            Jenkins.get().setSecurityRealm(Realm);
            DescriptorImpl.persistChanges();
        }

        @POST
        public FormValidation doCheckIdpEntityId(@QueryParameter String idpEntityId) {
            DescriptorImpl.checkAdminPermission();
            if (StringUtils.isEmpty((String)idpEntityId)) {
                return FormValidation.error((String)"The Entity ID Can not be kept blank.");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckSsoUrl(@QueryParameter String ssoUrl) {
            DescriptorImpl.checkAdminPermission();
            if (StringUtils.isEmpty((String)ssoUrl)) {
                return FormValidation.error((String)"The Single Sign On URL Can not be kept blank.");
            }
            try {
                new URL(ssoUrl);
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)"The URL is malformed.", (Object[])new Object[]{e});
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckUsernameAttribute(@QueryParameter String usernameAttribute, @QueryParameter String loginType) {
            DescriptorImpl.checkAdminPermission();
            if (StringUtils.isEmpty((String)usernameAttribute) && loginType.equals("usernameLogin")) {
                return FormValidation.warning((String)"Username Can not kept blank");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckEmailAttribute(@QueryParameter String emailAttribute, @QueryParameter String loginType) {
            DescriptorImpl.checkAdminPermission();
            if (StringUtils.isEmpty((String)emailAttribute) && loginType.equals("emailLogin")) {
                return FormValidation.warning((String)"Email Address Can not kept blank");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckPublicx509Certificate(@QueryParameter String publicx509Certificate) {
            DescriptorImpl.checkAdminPermission();
            if (StringUtils.isEmpty((String)publicx509Certificate)) {
                return FormValidation.error((String)"Certificate cannot be kept blank.");
            }
            if (StringUtils.isNotBlank((String)publicx509Certificate)) {
                Boolean validCertificate = MoSAMLUtils.isValidPublicCertificate(publicx509Certificate);
                LOGGER.fine("is certificate valid:" + validCertificate);
                if (validCertificate.booleanValue()) {
                    return FormValidation.ok();
                }
                return FormValidation.error((String)"Invalid Certificate");
            }
            return FormValidation.error((String)"Certificate validation failed.");
        }

        @POST
        public FormValidation doCheckRegexPattern(@QueryParameter Boolean enableRegexPattern, @QueryParameter String regexPattern) {
            DescriptorImpl.checkAdminPermission();
            if (enableRegexPattern.booleanValue() && StringUtils.isEmpty((String)regexPattern)) {
                return FormValidation.error((String)"The Regex Pattern is not Valid");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doUserCreate(@QueryParameter Boolean userCreate, @QueryParameter String emailAttribute, @QueryParameter String usernameAttribute) {
            DescriptorImpl.checkAdminPermission();
            if (userCreate.booleanValue() && StringUtils.isEmpty((String)emailAttribute) && StringUtils.isEmpty((String)usernameAttribute)) {
                return FormValidation.error((String)"Email and Username Attributes are required.");
            }
            return FormValidation.ok();
        }

        public String getBaseUrl() {
            String rootURL = Jenkins.get().getRootUrl();
            if (rootURL.endsWith("/")) {
                rootURL = rootURL.substring(0, rootURL.length() - 1);
            }
            return rootURL;
        }

        @POST
        public FormValidation doCheckSslUrl(@QueryParameter String sslUrl) {
            DescriptorImpl.checkAdminPermission();
            return FormValidation.warning((String)"Available in premium version");
        }

        @POST
        public FormValidation doCheckUserAttributeUpdate(@QueryParameter Boolean userAttributeUpdate) {
            DescriptorImpl.checkAdminPermission();
            if (!userAttributeUpdate.booleanValue()) {
                return FormValidation.warning((String)"Available in premium version");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckSignedRequest(@QueryParameter Boolean signedRequest) {
            DescriptorImpl.checkAdminPermission();
            if (!signedRequest.booleanValue()) {
                return FormValidation.warning((String)"Available in premium version");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckSplitnameAttribute(@QueryParameter Boolean splitnameAttribute) {
            DescriptorImpl.checkAdminPermission();
            return FormValidation.warning((String)"Available in premium version");
        }

        @POST
        public FormValidation doCheckDisableDefaultLogin(@QueryParameter Boolean disableDefaultLogin) {
            DescriptorImpl.checkAdminPermission();
            if (!disableDefaultLogin.booleanValue()) {
                return FormValidation.warning((String)"Available in premium version");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckGroupAttribute(@QueryParameter String groupAttribute) {
            DescriptorImpl.checkAdminPermission();
            return FormValidation.warning((String)"Available in premium version");
        }

        @POST
        public FormValidation doCheckNewUserGroup(@QueryParameter String newUserGroup) {
            DescriptorImpl.checkAdminPermission();
            return FormValidation.warning((String)"Available in premium version");
        }

        @POST
        public FormValidation doCheckUpdateUserFromCrowd(@QueryParameter Boolean updateUserFromCrowd) {
            DescriptorImpl.checkAdminPermission();
            return FormValidation.warning((String)"Available in premium version");
        }

        @POST
        public FormValidation doCheckUpdateNestedGroupsFromCrowd(@QueryParameter Boolean updateNestedGroupsFromCrowd) {
            DescriptorImpl.checkAdminPermission();
            return FormValidation.warning((String)"Available in premium version");
        }

        @POST
        public FormValidation doCheckUseCrowdNativeLogin(@QueryParameter Boolean useCrowdNativeLogin) {
            DescriptorImpl.checkAdminPermission();
            return FormValidation.warning((String)"Available in premium version");
        }

        @POST
        public FormValidation doCheckFullnameAttribute(@QueryParameter String updateNestedGroupsFromCrowd) {
            DescriptorImpl.checkAdminPermission();
            return FormValidation.warning((String)"Available in premium version");
        }

        @POST
        public FormValidation doCheckEnableCustomLoginTemplate(@QueryParameter Boolean enableCustomLoginTemplate) {
            DescriptorImpl.checkAdminPermission();
            return FormValidation.warning((String)"Available in premium version");
        }

        @POST
        public FormValidation doPerformTestConfiguration(@QueryParameter String idpEntityId, @QueryParameter String ssoUrl, @QueryParameter String publicx509Certificate) {
            DescriptorImpl.checkAdminPermission();
            if (StringUtils.isEmpty((String)idpEntityId) || StringUtils.isEmpty((String)ssoUrl) || StringUtils.isEmpty((String)publicx509Certificate)) {
                LOGGER.fine("Entity ID is " + idpEntityId);
                LOGGER.fine("ssoUrl is " + ssoUrl);
                LOGGER.fine("publicx509Certificate is " + publicx509Certificate);
                return FormValidation.error((String)"Save the idp configurations first. Could not perform test config");
            }
            LOGGER.fine("Test config called..");
            String testConfigUrl = this.getBaseUrl() + "/securityRealm/moSamlLogin?from=testidpconfiguration";
            return FormValidation.okWithMarkup((String)("Click <a href='" + testConfigUrl + "' target='_blank' >here</a> to see the test configurations result."));
        }

        @POST
        public FormValidation doValidateMetadataUrl(@QueryParameter String metadataUrl) throws Exception {
            DescriptorImpl.checkAdminPermission();
            String metadata = MoHttpUtils.sendGetRequest(metadataUrl, null);
            try {
                List<String> list = MoSAMLAddIdp.configureFromMetadata(metadata);
            }
            catch (Exception e) {
                LOGGER.fine("Invalid metadata Url" + e);
                return FormValidation.error((String)"Invalid metadata Url");
            }
            return FormValidation.okWithMarkup((String)"Valid metadata Url, please hit save button");
        }

        @POST
        public FormValidation doValidateMetadataFile(@QueryParameter String metadataFilePath) throws Exception {
            DescriptorImpl.checkAdminPermission();
            String metadata = MoSAMLAddIdp.getMetadataFromFile(metadataFilePath);
            try {
                List<String> list = MoSAMLAddIdp.configureFromMetadata(metadata);
            }
            catch (Exception e) {
                LOGGER.fine("File not found or wrong file extension");
                return FormValidation.error((String)"File not found or wrong file extension");
            }
            return FormValidation.okWithMarkup((String)"Validation successful, please hit save button");
        }
    }
}

