/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.mcp.server.extensions;

import hudson.model.Run;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.SuiteResult;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import io.jenkins.plugins.mcp.server.McpServerExtension;
import io.jenkins.plugins.mcp.server.annotation.Tool;
import io.jenkins.plugins.mcp.server.annotation.ToolParam;
import io.jenkins.plugins.mcp.server.extensions.util.JenkinsUtil;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.jenkinsci.plugins.variant.OptionalExtension;

@OptionalExtension(requirePlugins={"junit"})
public class TestResultExtension
implements McpServerExtension {
    @Tool(description="Retrieves the test results associated to a Jenkins build", annotations=@Tool.Annotations(destructiveHint=false))
    public Map<String, Object> getTestResults(@ToolParam(description="Job full name of the Jenkins job (e.g., 'folder/job-name')") String jobFullName, @Nullable @ToolParam(description="Build number (optional, if not provided, returns the test results for last build)", required=false) Integer buildNumber, @Nullable @ToolParam(description="To return only failing tests and not all test (to help reducing the size of returned data)", required=false) Boolean onlyFailingTests) {
        TestResultAction testResultAction;
        Optional<Run> run = JenkinsUtil.getBuildByNumberOrLast(jobFullName, buildNumber);
        if (run.isPresent() && (testResultAction = (TestResultAction)run.get().getAction(TestResultAction.class)) != null) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("TestResultAction", testResultAction);
            TestResult result = testResultAction.getResult();
            if (result != null) {
                if (Boolean.TRUE.equals(onlyFailingTests)) {
                    List<hudson.tasks.junit.CaseResult> failingTests = result.getTestResult().getSuites().stream().flatMap(suiteResult -> suiteResult.getCases().stream()).filter(caseResult -> caseResult.getStatus() == CaseResult.Status.FAILED).toList();
                    response.put("failingTests", failingTests);
                } else {
                    response.put("TestResult", result);
                }
            }
            return response;
        }
        return Map.of();
    }

    @Tool(description="Retrieves the flaky failures associated to a Jenkins build if any found", annotations=@Tool.Annotations(destructiveHint=false))
    public Map<String, Object> getFlakyFailures(@ToolParam(description="Job full name of the Jenkins job (e.g., 'folder/job-name')") String jobFullName, @Nullable @ToolParam(description="Build number (optional, if not provided, returns the test results for last build)", required=false) Integer buildNumber) {
        TestResultAction testResultAction;
        Optional<Run> run = JenkinsUtil.getBuildByNumberOrLast(jobFullName, buildNumber);
        if (run.isPresent() && (testResultAction = (TestResultAction)run.get().getAction(TestResultAction.class)) != null) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("TestResultAction", testResultAction);
            TestResult result = testResultAction.getResult();
            if (result != null) {
                List<CaseResult> flakyFailures = result.getTestResult().getSuites().stream().map(SuiteResult::getCases).flatMap(Collection::stream).filter(caseResult -> !caseResult.getFlakyFailures().isEmpty()).map(caseResult -> new CaseResult(caseResult.getDuration(), caseResult.getClassName(), caseResult.getName(), caseResult.getSkippedMessage(), caseResult.isSkipped(), caseResult.getErrorStackTrace(), caseResult.getErrorDetails(), caseResult.getFailedSince(), caseResult.getStdout(), caseResult.getStderr(), caseResult.getProperties(), caseResult.getFlakyFailures().stream().map(flakyFailure -> new FlakyFailure(flakyFailure.message(), flakyFailure.type(), flakyFailure.stackTrace(), flakyFailure.stdout(), flakyFailure.stderr())).toList())).toList();
                response.put("TestResultWithFlakyFailures", flakyFailures);
            }
            return response;
        }
        return Map.of();
    }

    public static final class CaseResult {
        private float duration;
        private String className;
        private String testName;
        private String skippedMessage;
        private boolean skipped;
        private String errorStackTrace;
        private String errorDetails;
        private int failedSince;
        private String stdout;
        private String stderr;
        private Map<String, String> properties;
        private List<FlakyFailure> flakyFailures;

        public CaseResult(float duration, String className, String testName, String skippedMessage, boolean skipped, String errorStackTrace, String errorDetails, int failedSince, String stdout, String stderr, Map<String, String> properties, List<FlakyFailure> flakyFailures) {
            this.duration = duration;
            this.className = className;
            this.testName = testName;
            this.skippedMessage = skippedMessage;
            this.skipped = skipped;
            this.errorStackTrace = errorStackTrace;
            this.errorDetails = errorDetails;
            this.failedSince = failedSince;
            this.stdout = stdout;
            this.stderr = stderr;
            this.properties = properties;
            this.flakyFailures = flakyFailures;
        }

        @Generated
        public float getDuration() {
            return this.duration;
        }

        @Generated
        public String getClassName() {
            return this.className;
        }

        @Generated
        public String getTestName() {
            return this.testName;
        }

        @Generated
        public String getSkippedMessage() {
            return this.skippedMessage;
        }

        @Generated
        public boolean isSkipped() {
            return this.skipped;
        }

        @Generated
        public String getErrorStackTrace() {
            return this.errorStackTrace;
        }

        @Generated
        public String getErrorDetails() {
            return this.errorDetails;
        }

        @Generated
        public int getFailedSince() {
            return this.failedSince;
        }

        @Generated
        public String getStdout() {
            return this.stdout;
        }

        @Generated
        public String getStderr() {
            return this.stderr;
        }

        @Generated
        public Map<String, String> getProperties() {
            return this.properties;
        }

        @Generated
        public List<FlakyFailure> getFlakyFailures() {
            return this.flakyFailures;
        }

        @Generated
        public void setDuration(float duration) {
            this.duration = duration;
        }

        @Generated
        public void setClassName(String className) {
            this.className = className;
        }

        @Generated
        public void setTestName(String testName) {
            this.testName = testName;
        }

        @Generated
        public void setSkippedMessage(String skippedMessage) {
            this.skippedMessage = skippedMessage;
        }

        @Generated
        public void setSkipped(boolean skipped) {
            this.skipped = skipped;
        }

        @Generated
        public void setErrorStackTrace(String errorStackTrace) {
            this.errorStackTrace = errorStackTrace;
        }

        @Generated
        public void setErrorDetails(String errorDetails) {
            this.errorDetails = errorDetails;
        }

        @Generated
        public void setFailedSince(int failedSince) {
            this.failedSince = failedSince;
        }

        @Generated
        public void setStdout(String stdout) {
            this.stdout = stdout;
        }

        @Generated
        public void setStderr(String stderr) {
            this.stderr = stderr;
        }

        @Generated
        public void setProperties(Map<String, String> properties) {
            this.properties = properties;
        }

        @Generated
        public void setFlakyFailures(List<FlakyFailure> flakyFailures) {
            this.flakyFailures = flakyFailures;
        }
    }

    public static final class FlakyFailure {
        private final String message;
        private final String type;
        private final String stackTrace;
        private final String stdout;
        private final String stderr;

        public FlakyFailure(String message, String type, String stackTrace, String stdout, String stderr) {
            this.message = message;
            this.type = type;
            this.stackTrace = stackTrace;
            this.stdout = stdout;
            this.stderr = stderr;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getStackTrace() {
            return this.stackTrace;
        }

        @Generated
        public String getStdout() {
            return this.stdout;
        }

        @Generated
        public String getStderr() {
            return this.stderr;
        }
    }
}

