/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.mcp.server.extensions.scm;

import hudson.model.Run;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitObject;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.BuildData;
import hudson.scm.SCM;
import io.jenkins.plugins.mcp.server.extensions.scm.GitScmConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.transport.URIish;

public class GitScmUtil {
    public static GitScmConfig extractGitScmInfo(SCM scm) {
        if (scm instanceof GitSCM) {
            GitSCM gitSCM = (GitSCM)scm;
            List<String> branches = gitSCM.getBranches().stream().map(BranchSpec::getName).toList();
            List<String> uris = gitSCM.getRepositories().stream().flatMap(repo -> repo.getURIs().stream()).map(URIish::toString).toList();
            return new GitScmConfig(uris, branches, null);
        }
        return null;
    }

    public static GitScmConfig extractGitScmInfo(Run run) {
        return Optional.ofNullable((BuildData)run.getAction(BuildData.class)).map(buildData -> {
            List<String> branches = Optional.of(buildData).map(BuildData::getLastBuiltRevision).map(Revision::getBranches).stream().flatMap(Collection::stream).map(GitObject::getName).toList();
            String commit = Optional.of(buildData).map(BuildData::getLastBuiltRevision).map(Revision::getSha1).map(AnyObjectId::toString).orElse(null);
            return new GitScmConfig(new ArrayList<String>(buildData.getRemoteUrls()), branches, commit);
        }).orElse(null);
    }
}

