/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.orka.helpers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class ImageRegexOCI {
    private static final String REGISTRY_COMPONENT_REGEX = "(?:[a-zA-Z\\d]|(?:[a-zA-Z\\d][a-zA-Z\\d-]*[a-zA-Z\\d]))";
    private static final String REGISTRY_REGEX = String.format("%s(?:\\.%s)*(?::\\d+)?", "(?:[a-zA-Z\\d]|(?:[a-zA-Z\\d][a-zA-Z\\d-]*[a-zA-Z\\d]))", "(?:[a-zA-Z\\d]|(?:[a-zA-Z\\d][a-zA-Z\\d-]*[a-zA-Z\\d]))");
    private static final String REPOSITORY_COMPONENT_REGEX = "[a-z\\d]+(?:(?:[_.]|__|-+)[a-z\\d]+)*";
    private static final String REPOSITORY_REGEX = String.format("(?:%s/)*%s", "[a-z\\d]+(?:(?:[_.]|__|-+)[a-z\\d]+)*", "[a-z\\d]+(?:(?:[_.]|__|-+)[a-z\\d]+)*");
    private static final String TAG_REGEX = "[\\w][\\w.-]{0,127}";
    private static final int HASH_LENGTH = 64;
    private static final String HASH_REGEX = String.format("[a-f0-9]{%d}", 64);
    private static final String DIGEST_PREFIX = "sha256:";
    static final String DIGEST_REGEX = "sha256:" + HASH_REGEX;
    private static final String REFERENCE_REGEX = String.format("^(?:(%s)/)?(%s)(?::(%s))?(?:@(%s))?$", REGISTRY_REGEX, REPOSITORY_REGEX, "[\\w][\\w.-]{0,127}", DIGEST_REGEX);
    private static final Pattern REFERENCE_PATTERN = Pattern.compile(REFERENCE_REGEX);

    public static boolean isValidOCI(String reference) {
        Matcher matcher = REFERENCE_PATTERN.matcher(reference);
        if (!matcher.find() || matcher.groupCount() < 4) {
            return false;
        }
        String registry = matcher.group(1);
        String repository = matcher.group(2);
        if (StringUtils.isEmpty((String)registry)) {
            return false;
        }
        if (StringUtils.isEmpty((String)repository)) {
            return false;
        }
        return registry.contains(".") || registry.contains(":") || "localhost".equals(registry);
    }
}

