/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.kubernetes.ephemeral.rules;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import io.jenkins.plugins.kubernetes.ephemeral.EphemeralContainerStep;
import io.jenkins.plugins.kubernetes.ephemeral.EphemeralContainerStepRule;
import io.jenkins.plugins.kubernetes.ephemeral.ImageReference;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class ContainerImageRule
extends EphemeralContainerStepRule {
    private final String names;
    private final EphemeralContainerStepRule.Action action;
    private transient Pattern regex;

    public ContainerImageRule() {
        this("*", EphemeralContainerStepRule.Action.ALLOW);
    }

    @DataBoundConstructor
    public ContainerImageRule(String names, EphemeralContainerStepRule.Action action) {
        this.names = StringUtils.trimToEmpty((String)names);
        this.action = action == null ? EphemeralContainerStepRule.Action.ALLOW : action;
    }

    @NonNull
    private Pattern getNamesRegex() {
        if (this.regex == null) {
            this.regex = Pattern.compile(ContainerImageRule.wildcardPatternsToRegex(this.names));
        }
        return this.regex;
    }

    static String wildcardPatternsToRegex(@NonNull String patterns) {
        String p = patterns.lines().map(String::trim).filter(Predicate.not(String::isEmpty)).filter(s -> !s.startsWith("#")).map(ContainerImageRule::wildcardToRegex).collect(Collectors.joining("|"));
        return p.isBlank() ? "" : "^(" + p + ")$";
    }

    private static String wildcardToRegex(String pattern) {
        CharSequence[] list = StringUtils.splitPreserveAllTokens((String)pattern, (String)"*");
        for (int i = 0; i < list.length; ++i) {
            if (StringUtils.equals((CharSequence)list[i], (CharSequence)"")) continue;
            list[i] = Pattern.quote((String)list[i]);
        }
        return String.join((CharSequence)".*", list);
    }

    @Override
    @NonNull
    public Optional<EphemeralContainerStepRule.Result> test(@NonNull EphemeralContainerStep step) {
        Optional<ImageReference> reference = ImageReference.parse(step.getImage());
        if (reference.isEmpty()) {
            return Optional.of(EphemeralContainerStepRule.Result.reject("Invalid image reference"));
        }
        Predicate<String> matcher = this.getNamesRegex().asMatchPredicate();
        if (matcher.test(reference.get().getName())) {
            if (this.action == EphemeralContainerStepRule.Action.REJECT) {
                return Optional.of(EphemeralContainerStepRule.Result.reject("Image '" + step.getImage() + "' has been disallowed by Jenkins administrators."));
            }
            return Optional.of(new EphemeralContainerStepRule.Result(this.action));
        }
        if (this.action == EphemeralContainerStepRule.Action.ALLOW) {
            return Optional.of(EphemeralContainerStepRule.Result.reject("Image '" + step.getImage() + "' not in allow list"));
        }
        return Optional.empty();
    }

    @NonNull
    public String getNames() {
        return this.names;
    }

    @NonNull
    public EphemeralContainerStepRule.Action getAction() {
        return this.action;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SIMPLE_STYLE).append("action", (Object)this.action).append("names", (Object)this.names).toString();
    }

    @Extension
    @Symbol(value={"containerImageRule"})
    public static class DescriptorImpl
    extends Descriptor<EphemeralContainerStepRule> {
        @NonNull
        public String getDisplayName() {
            return "Container Image Rule";
        }
    }
}

