/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.kubernetes.ephemeral;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import io.jenkins.plugins.kubernetes.ephemeral.EphemeralContainerStep;
import io.jenkins.plugins.kubernetes.ephemeral.EphemeralContainerStepRule;
import java.util.Optional;
import java.util.logging.Logger;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
class EphemeralContainerStepRuleEvaluator {
    private static final Logger LOGGER = Logger.getLogger(EphemeralContainerStepRuleEvaluator.class.getName());

    EphemeralContainerStepRuleEvaluator() {
    }

    public void eval(@NonNull EphemeralContainerStep step, @NonNull Iterable<? extends EphemeralContainerStepRule> rules) throws AbortException {
        for (EphemeralContainerStepRule ephemeralContainerStepRule : rules) {
            EphemeralContainerStepRule.Result result;
            Optional<EphemeralContainerStepRule.Result> action = ephemeralContainerStepRule.test(step);
            if (!action.isPresent() || (result = action.get()).getAction() != EphemeralContainerStepRule.Action.REJECT) continue;
            LOGGER.info(() -> "Ephemeral container step rejected, reason=" + result.getReason().orElse("none") + ", step=" + String.valueOf(step) + ", rule=" + String.valueOf((Object)rule));
            throw new AbortException(result.getReason().orElse("Ephemeral container step rejected due to " + String.valueOf((Object)ephemeralContainerStepRule)));
        }
    }
}

