/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.jfrog.callables;

import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import jenkins.MasterToSlaveFileCallable;

public class TempDirCreator
extends MasterToSlaveFileCallable<FilePath> {
    private String workspaceList;
    private FilePath ws;

    public FilePath invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
        FilePath tempDir = this.ws.sibling(this.ws.getName() + Objects.toString(this.workspaceList, "@") + "tmp");
        if (tempDir == null) {
            throw new RuntimeException("Failed to create JFrog CLI temporary directory");
        }
        File tempDirFile = new File((tempDir = tempDir.child("jfrog")).getRemote());
        if (tempDirFile.mkdirs()) {
            tempDirFile.deleteOnExit();
        }
        return tempDir;
    }

    public TempDirCreator(String workspaceList, FilePath ws) {
        this.workspaceList = workspaceList;
        this.ws = ws;
    }
}

