/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.jfrog;

import hudson.FilePath;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolInstallerDescriptor;
import hudson.util.Secret;
import io.jenkins.plugins.jfrog.JenkinsBuildInfoLog;
import io.jenkins.plugins.jfrog.OsUtils;
import io.jenkins.plugins.jfrog.callables.JFrogCliDownloader;
import io.jenkins.plugins.jfrog.configuration.JFrogPlatformInstance;
import io.jenkins.plugins.jfrog.configuration.JenkinsProxyConfiguration;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ProxyConfiguration;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;

public abstract class BinaryInstaller
extends ToolInstaller {
    private static final Logger LOGGER = Logger.getLogger(BinaryInstaller.class.getName());
    private static final ConcurrentHashMap<String, Object> NODE_INSTALLATION_LOCKS = new ConcurrentHashMap();

    protected BinaryInstaller(String label) {
        super(label);
    }

    protected FilePath getToolLocation(ToolInstallation tool, Node node) throws IOException, InterruptedException {
        FilePath location = this.preferredLocation(tool, node);
        if (!location.exists()) {
            location.mkdirs();
        }
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FilePath performJfrogCliInstallation(FilePath toolLocation, TaskListener log, String version, JFrogPlatformInstance instance, String repository, String binaryName) throws IOException, InterruptedException {
        String lockKey = BinaryInstaller.createLockKey(toolLocation, binaryName, version);
        Object installationLock = NODE_INSTALLATION_LOCKS.computeIfAbsent(lockKey, k -> new Object());
        log.getLogger().println("[BinaryInstaller] Acquiring installation lock for: " + lockKey);
        Object object = installationLock;
        synchronized (object) {
            log.getLogger().println("[BinaryInstaller] Lock acquired, proceeding with installation");
            try {
                FilePath cliPath = toolLocation.child(binaryName);
                if (BinaryInstaller.isValidCliInstallation(cliPath, log) && BinaryInstaller.isCorrectVersion(toolLocation, instance, repository, version, log)) {
                    log.getLogger().println("[BinaryInstaller] CLI already installed and up-to-date, skipping download");
                    FilePath filePath = toolLocation;
                    return filePath;
                }
                if (BinaryInstaller.isValidCliInstallation(cliPath, log)) {
                    log.getLogger().println("[BinaryInstaller] CLI exists but version mismatch detected, proceeding with upgrade");
                } else {
                    log.getLogger().println("[BinaryInstaller] No valid CLI installation found, proceeding with fresh installation");
                }
                BinaryInstaller.cleanupStaleLocks(toolLocation, binaryName, version);
                log.getLogger().println("[BinaryInstaller] Starting CLI installation process");
                JenkinsProxyConfiguration proxyConfiguration = new JenkinsProxyConfiguration();
                toolLocation.act((FilePath.FileCallable)new JFrogCliDownloader(proxyConfiguration, version, instance, log, repository, binaryName));
                log.getLogger().println("[BinaryInstaller] CLI installation completed successfully");
                FilePath filePath = toolLocation;
                return filePath;
            }
            finally {
                log.getLogger().println("[BinaryInstaller] Installation lock released for: " + lockKey);
            }
        }
    }

    private static String createLockKey(FilePath toolLocation, String binaryName, String version) {
        try {
            return toolLocation.getRemote() + "/" + binaryName + "/" + version;
        }
        catch (Exception e) {
            return toolLocation.toString() + "/" + binaryName + "/" + version;
        }
    }

    private static boolean isValidCliInstallation(FilePath cliPath, TaskListener log) {
        try {
            long fileSize;
            if (cliPath.exists() && (fileSize = cliPath.length()) > 0x100000L) {
                log.getLogger().println("[BinaryInstaller] Found existing CLI: " + cliPath.getRemote() + " (size: " + fileSize / 1024L / 1024L + "MB)");
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.warning("Failed to check existing CLI installation: " + e.getMessage());
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isCorrectVersion(FilePath toolLocation, JFrogPlatformInstance instance, String repository, String version, TaskListener log) {
        try {
            JenkinsProxyConfiguration proxyConfiguration = new JenkinsProxyConfiguration();
            String cliUrlSuffix = String.format("/%s/v2-jf/%s/jfrog-cli-%s/jf", repository, StringUtils.defaultIfBlank((CharSequence)version, (CharSequence)"[RELEASE]"), OsUtils.getOsDetails());
            JenkinsBuildInfoLog buildInfoLog = new JenkinsBuildInfoLog(log);
            String artifactoryUrl = instance.inferArtifactoryUrl();
            try (ArtifactoryManager manager = new ArtifactoryManager(artifactoryUrl, Secret.toString((Secret)instance.getCredentialsConfig().getUsername()), Secret.toString((Secret)instance.getCredentialsConfig().getPassword()), Secret.toString((Secret)instance.getCredentialsConfig().getAccessToken()), (Log)buildInfoLog);){
                String expectedSha256;
                if (proxyConfiguration.isProxyConfigured(artifactoryUrl)) {
                    manager.setProxyConfiguration((ProxyConfiguration)proxyConfiguration);
                }
                if ((expectedSha256 = BinaryInstaller.getArtifactSha256(manager, cliUrlSuffix)).isEmpty()) {
                    log.getLogger().println("[BinaryInstaller] No SHA256 available from server, assuming version check needed");
                    boolean bl = false;
                    return bl;
                }
                boolean bl = (Boolean)toolLocation.act((FilePath.FileCallable)new MasterToSlaveFileCallable<Boolean>(){

                    public Boolean invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
                        File sha256File = new File(f, "sha256");
                        if (!sha256File.exists()) {
                            return false;
                        }
                        String localSha256 = new String(Files.readAllBytes(sha256File.toPath()), StandardCharsets.UTF_8);
                        return BinaryInstaller.constantTimeEquals(expectedSha256, localSha256);
                    }
                });
                return bl;
            }
        }
        catch (Exception e) {
            log.getLogger().println("[BinaryInstaller] Version check failed: " + e.getMessage() + ", proceeding with download check");
            return false;
        }
    }

    private static String getArtifactSha256(ArtifactoryManager manager, String cliUrlSuffix) throws IOException {
        Header[] headers;
        for (Header header : headers = manager.downloadHeaders(cliUrlSuffix)) {
            if (!header.getName().equalsIgnoreCase("X-Checksum-Sha256")) continue;
            return header.getValue();
        }
        return "";
    }

    private static void cleanupStaleLocks(FilePath toolLocation, String binaryName, String currentVersion) {
        try {
            String locationPrefix = toolLocation.getRemote() + "/" + binaryName + "/";
            String currentLockKey = locationPrefix + currentVersion;
            NODE_INSTALLATION_LOCKS.entrySet().removeIf(entry -> {
                String key = (String)entry.getKey();
                return key.startsWith(locationPrefix) && !key.equals(currentLockKey);
            });
        }
        catch (Exception e) {
            LOGGER.fine("Failed to cleanup stale locks: " + e.getMessage());
        }
    }

    private static boolean constantTimeEquals(String a, String b) {
        if (a == null || b == null) {
            return Objects.equals(a, b);
        }
        if (a.length() != b.length()) {
            return false;
        }
        int result = 0;
        for (int i = 0; i < a.length(); ++i) {
            result |= a.charAt(i) ^ b.charAt(i);
        }
        return result == 0;
    }

    public static abstract class DescriptorImpl<T extends BinaryInstaller>
    extends ToolInstallerDescriptor<T> {
        public String getId() {
            return this.clazz.getName().replace('$', '.');
        }
    }
}

