/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.insightappsec;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.insightappsec.BuildAdvanceIndicator;
import io.jenkins.plugins.insightappsec.DescriptorHelper;
import io.jenkins.plugins.insightappsec.DurationStringParser;
import io.jenkins.plugins.insightappsec.InsightAppSecLogger;
import io.jenkins.plugins.insightappsec.InsightAppSecScanStepRunner;
import io.jenkins.plugins.insightappsec.Messages;
import io.jenkins.plugins.insightappsec.Region;
import io.jenkins.plugins.insightappsec.ScanDurationHandler;
import io.jenkins.plugins.insightappsec.ScanResultHandler;
import io.jenkins.plugins.insightappsec.ScanResults;
import io.jenkins.plugins.insightappsec.api.APIFactory;
import io.jenkins.plugins.insightappsec.api.HttpClientCache;
import io.jenkins.plugins.insightappsec.api.scan.ScanApi;
import io.jenkins.plugins.insightappsec.api.search.SearchApi;
import io.jenkins.plugins.insightappsec.credentials.InsightCredentialsHelper;
import java.util.Objects;
import java.util.Optional;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class InsightAppSecScanStep
extends Builder
implements SimpleBuildStep {
    private static final InsightCredentialsHelper INSIGHT_CREDENTIALS_HELPER = new InsightCredentialsHelper();
    private static final DurationStringParser DURATION_STRING_PARSER = new DurationStringParser();
    private static final ScanResultHandler SCAN_RESULT_HANDLER = new ScanResultHandler();
    private static final APIFactory API_FACTORY = new APIFactory(INSIGHT_CREDENTIALS_HELPER, HttpClientCache.SEARCH_API_HTTP_CLIENT, HttpClientCache.APP_API_HTTP_CLIENT, HttpClientCache.SCAN_API_HTTP_CLIENT);
    private final String region;
    private final String insightCredentialsId;
    private final String appId;
    private final String scanConfigId;
    private final String buildAdvanceIndicator;
    private final String vulnerabilityQuery;
    private final String maxScanPendingDuration;
    private final String maxScanExecutionDuration;
    private final boolean enableScanResults;

    @DataBoundConstructor
    public InsightAppSecScanStep(String region, String insightCredentialsId, String appId, String scanConfigId, String buildAdvanceIndicator, String vulnerabilityQuery, String maxScanPendingDuration, String maxScanExecutionDuration, boolean enableScanResults) {
        this.region = Region.fromString(region).name();
        this.insightCredentialsId = Util.fixEmptyAndTrim((String)insightCredentialsId);
        this.appId = Util.fixEmptyAndTrim((String)appId);
        this.scanConfigId = Util.fixEmptyAndTrim((String)scanConfigId);
        this.buildAdvanceIndicator = BuildAdvanceIndicator.fromString(buildAdvanceIndicator).name();
        this.vulnerabilityQuery = Util.fixEmptyAndTrim((String)vulnerabilityQuery);
        this.maxScanPendingDuration = Util.fixEmptyAndTrim((String)maxScanPendingDuration);
        this.maxScanExecutionDuration = Util.fixEmptyAndTrim((String)maxScanExecutionDuration);
        this.enableScanResults = enableScanResults;
        this.validateConfiguration();
    }

    public String getRegion() {
        return this.region;
    }

    public String getInsightCredentialsId() {
        return this.insightCredentialsId;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getScanConfigId() {
        return this.scanConfigId;
    }

    public String getBuildAdvanceIndicator() {
        return this.buildAdvanceIndicator;
    }

    public String getVulnerabilityQuery() {
        return this.vulnerabilityQuery;
    }

    public String getMaxScanPendingDuration() {
        return this.maxScanPendingDuration;
    }

    public String getMaxScanExecutionDuration() {
        return this.maxScanExecutionDuration;
    }

    public boolean isEnableScanResults() {
        return this.enableScanResults;
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException {
        InsightAppSecLogger logger = new InsightAppSecLogger(listener.getLogger());
        logger.log("Beginning AppSec scan step with configuration: %n%s", this.toString());
        BuildAdvanceIndicator bai = BuildAdvanceIndicator.fromString(this.buildAdvanceIndicator);
        Optional<ScanResults> scanResults = this.newRunner(logger).run(this.scanConfigId, bai, this.vulnerabilityQuery);
        scanResults.ifPresent(sr -> SCAN_RESULT_HANDLER.handleScanResults(run, logger, bai, (ScanResults)sr, this.enableScanResults));
    }

    private void validateConfiguration() {
        Objects.requireNonNull(this.region, "Region must not be null");
        Objects.requireNonNull(this.insightCredentialsId, "Insight Credentials ID must not be null");
        Objects.requireNonNull(this.scanConfigId, "Scan Config ID must not be null");
        Objects.requireNonNull(this.buildAdvanceIndicator, "Build Advance Indicator must not be null");
    }

    private InsightAppSecScanStepRunner newRunner(InsightAppSecLogger logger) {
        ScanApi scanApi = API_FACTORY.newScanApi(this.region, this.insightCredentialsId);
        SearchApi searchApi = API_FACTORY.newSearchApi(this.region, this.insightCredentialsId);
        return new InsightAppSecScanStepRunner(scanApi, searchApi, logger, this.newScanDurationHandler(scanApi, logger));
    }

    private ScanDurationHandler newScanDurationHandler(ScanApi scanApi, InsightAppSecLogger logger) {
        Long maxScanPendingDuration = DURATION_STRING_PARSER.parseDurationString(this.maxScanPendingDuration);
        Long maxScanExecutionDuration = DURATION_STRING_PARSER.parseDurationString(this.maxScanExecutionDuration);
        return new ScanDurationHandler(BuildAdvanceIndicator.fromString(this.buildAdvanceIndicator), scanApi, logger, System.currentTimeMillis(), maxScanPendingDuration, maxScanExecutionDuration);
    }

    public String toString() {
        return "{\n  region='" + this.region + "'\n  insightCredentialsId='" + this.insightCredentialsId + "'\n  appId='" + this.appId + "'\n  scanConfigId='" + this.scanConfigId + "'\n  buildAdvanceIndicator='" + this.buildAdvanceIndicator + "'\n  vulnerabilityQuery='" + this.vulnerabilityQuery + "'\n  maxScanPendingDuration='" + this.maxScanPendingDuration + "'\n  maxScanExecutionDuration='" + this.maxScanExecutionDuration + "'\n  enableScanResults=" + this.enableScanResults + "\n}";
    }

    @Extension
    @Symbol(value={"insightAppSec"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private DescriptorHelper descriptorHelper = new DescriptorHelper(API_FACTORY, INSIGHT_CREDENTIALS_HELPER, DURATION_STRING_PARSER);

        public ListBoxModel doFillRegionItems() {
            return this.descriptorHelper.getRegionItems();
        }

        public FormValidation doCheckRegion(@QueryParameter String region) {
            return this.descriptorHelper.doCheckRequiredField(region);
        }

        public ListBoxModel doFillInsightCredentialsIdItems(@AncestorInPath Jenkins context) {
            return this.descriptorHelper.getInsightCredentialsIdItems(context);
        }

        public FormValidation doCheckInsightCredentialsId(@QueryParameter String insightCredentialsId) {
            return this.descriptorHelper.doCheckRequiredField(insightCredentialsId);
        }

        public ListBoxModel doFillAppIdItems(@QueryParameter String region, @QueryParameter String insightCredentialsId) {
            return this.descriptorHelper.getAppIdItems(region, insightCredentialsId);
        }

        public ListBoxModel doFillScanConfigIdItems(@QueryParameter String region, @QueryParameter String insightCredentialsId, @QueryParameter String appId) {
            return this.descriptorHelper.getScanConfigIdItems(region, insightCredentialsId, appId);
        }

        public FormValidation doCheckScanConfigId(@QueryParameter String scanConfigId) {
            return this.descriptorHelper.doCheckRequiredField(scanConfigId);
        }

        public ListBoxModel doFillBuildAdvanceIndicatorItems() {
            return this.descriptorHelper.getBuildAdvanceIndicatorItems();
        }

        public FormValidation doCheckBuildAdvanceIndicator(@QueryParameter String buildAdvanceIndicator) {
            return this.descriptorHelper.doCheckRequiredField(buildAdvanceIndicator);
        }

        public FormValidation doCheckVulnerabilityQuery() {
            return this.descriptorHelper.doCheckVulnerabilityQuery();
        }

        public FormValidation doCheckMaxScanPendingDuration(@QueryParameter String maxScanPendingDuration) {
            return this.descriptorHelper.doCheckMaxScanPendingDuration(maxScanPendingDuration);
        }

        public FormValidation doCheckMaxScanExecutionDuration(@QueryParameter String maxScanExecutionDuration) {
            return this.descriptorHelper.doCheckMaxScanExecutionDuration(maxScanExecutionDuration);
        }

        public FormValidation doCheckEnableScanResults() {
            return this.descriptorHelper.doCheckEnableScanResults();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.displayName();
        }
    }
}

