/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabchecks;

import hudson.model.TaskListener;
import io.jenkins.plugins.checks.api.ChecksDetails;
import io.jenkins.plugins.checks.api.ChecksPublisher;
import io.jenkins.plugins.gitlabchecks.CheckStatusToGitLabCommitStatus;
import io.jenkins.plugins.gitlabchecks.GitLabChecksContext;
import java.io.PrintWriter;
import java.util.Optional;
import org.gitlab4j.api.CommitsApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.models.CommitStatus;
import org.gitlab4j.models.Constants;
import org.jspecify.annotations.NonNull;

public class GitLabChecksPublisher
extends ChecksPublisher {
    private final GitLabChecksContext context;
    private final TaskListener listener;

    public GitLabChecksPublisher(GitLabChecksContext context, TaskListener listener) {
        this.context = context;
        this.listener = listener;
    }

    public void publish(@NonNull ChecksDetails details) {
        block11: {
            long projectId = this.context.projectId();
            String commitSha = this.context.getHeadSha();
            if (commitSha == null) {
                this.listener.getLogger().println("[GitLab Checks] Unable to find commit SHA");
                return;
            }
            Optional<Constants.CommitBuildState> buildState = CheckStatusToGitLabCommitStatus.makeBuildStatus(details);
            if (buildState.isEmpty()) {
                this.listener.getLogger().println("[GitLab Checks] Unable to convert check status and conclusion to GitLab commit build status");
                return;
            }
            Optional<CommitStatus> commitStatus = CheckStatusToGitLabCommitStatus.makeCommitStatus(details);
            if (commitStatus.isEmpty()) {
                return;
            }
            try (GitLabApi api = this.context.makeGitLabApi();){
                CommitsApi commitsApi = api.getCommitsApi();
                commitsApi.addCommitStatus((Object)projectId, commitSha, (Constants.CommitBuildState)buildState.orElse(null), commitStatus.get());
            }
            catch (GitLabApiException e) {
                PrintWriter ignored = this.listener.error("GitLab check publish failed with", new Object[]{e});
                if (ignored == null) break block11;
                ignored.close();
            }
        }
    }
}

