/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.checks.gitea;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import edu.hm.hafner.util.FilteredLog;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Job;
import hudson.model.Run;
import io.jenkins.plugins.checks.gitea.SCMFacade;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public abstract class GiteaChecksContext {
    private final Job<?, ?> job;
    private final String url;
    private final SCMFacade scmFacade;

    protected GiteaChecksContext(Job<?, ?> job, String url, SCMFacade scmFacade) {
        this.job = job;
        this.url = url;
        this.scmFacade = scmFacade;
    }

    public abstract String getHeadSha();

    public abstract String getRepoOwner();

    public abstract String getRepo();

    public abstract String getGiteaServerUrl();

    public abstract String getRepository();

    public abstract boolean isValid(FilteredLog var1);

    @CheckForNull
    protected abstract String getCredentialsId();

    public StandardCredentials getCredentials() {
        return this.getGiteaAppCredentials((String)StringUtils.defaultIfEmpty((CharSequence)this.getCredentialsId(), (CharSequence)""));
    }

    public String getURL() {
        return this.url;
    }

    protected Job<?, ?> getJob() {
        return this.job;
    }

    protected SCMFacade getScmFacade() {
        return this.scmFacade;
    }

    protected StandardCredentials getGiteaAppCredentials(String credentialsId) {
        return this.findGiteaAppCredentials(credentialsId).orElseThrow(() -> new IllegalStateException("No Gitea APP credentials available for job: " + this.getJob().getName()));
    }

    protected boolean hasGiteaAppCredentials() {
        return this.findGiteaAppCredentials((String)StringUtils.defaultIfEmpty((CharSequence)this.getCredentialsId(), (CharSequence)"")).isPresent();
    }

    protected boolean hasCredentialsId() {
        return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.getCredentialsId()});
    }

    protected boolean hasValidCredentials(FilteredLog logger) {
        if (!this.hasCredentialsId()) {
            logger.logError("No credentials found");
            return false;
        }
        if (!this.hasGiteaAppCredentials()) {
            logger.logError("No Gitea app credentials found: '%s'", new Object[]{this.getCredentialsId()});
            logger.logError("See: https://plugins.jenkins.io/gitea/");
            return false;
        }
        return true;
    }

    private Optional<StandardCredentials> findGiteaAppCredentials(String credentialsId) {
        return this.getScmFacade().findGiteaAppCredentials(this.getJob(), credentialsId);
    }

    protected abstract Optional<Run<?, ?>> getRun();
}

