/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitcollect;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitException;
import hudson.plugins.git.Revision;
import hudson.remoting.VirtualChannel;
import io.jenkins.plugins.gitcollect.LocalGitInfo;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.MasterToSlaveFileCallable;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.gitclient.GitClient;

@SuppressFBWarnings(value={"SE"}, justification="GitClient implementation is Serializable")
public class GitScanner
extends MasterToSlaveFileCallable<LocalGitInfo> {
    private static final long serialVersionUID = 1L;
    private final GitClient git;
    private final String markedCommit;
    private final String remote;
    public static final Logger LOGGER = Logger.getLogger(GitScanner.class.getName());

    public GitScanner(GitClient git, String markedCommit, String remote) {
        this.git = git;
        this.markedCommit = markedCommit;
        this.remote = remote;
    }

    public LocalGitInfo invoke(File workspace, VirtualChannel channel) throws IOException, InterruptedException {
        ObjectId topOnObjectId;
        ObjectId resolvedObjectId;
        String url = this.git.getRemoteUrl(this.remote);
        String referenceHead = this.markedCommit != null && !this.markedCommit.trim().isEmpty() ? this.markedCommit : "HEAD";
        try {
            resolvedObjectId = this.git.revParse(referenceHead);
        }
        catch (GitException e) {
            try {
                resolvedObjectId = this.git.revParse(this.remote + "/" + referenceHead);
            }
            catch (GitException e2) {
                throw new IOException("[GitCollect] Could not resolve revision '" + referenceHead + "' or '" + this.remote + "/" + referenceHead + "'", e);
            }
        }
        try {
            topOnObjectId = this.git.revParse("HEAD");
        }
        catch (GitException e) {
            throw new IOException("[GitCollect] Could not resolve revision '" + referenceHead + "'", e);
        }
        LOGGER.log(Level.FINE, "referenceHead: " + referenceHead);
        try {
            Revision builtRevision = new Revision(topOnObjectId);
            Revision markedRevision = new Revision(resolvedObjectId);
            ArrayList<Branch> branches = new ArrayList<Branch>();
            branches.add(new Branch(referenceHead, resolvedObjectId));
            builtRevision.setBranches(branches);
            if (this.markedCommit != null && !ObjectId.isId((String)this.markedCommit)) {
                branches = new ArrayList();
                branches.add(new Branch(this.markedCommit, resolvedObjectId));
                markedRevision.setBranches(branches);
            }
            URIish uri = new URIish(url);
            return new LocalGitInfo(uri.getHumanishName(), url, this.remote, builtRevision, markedRevision);
        }
        catch (URISyntaxException e) {
            throw new IOException("[GitCollect] Unable to find an uri name", e);
        }
    }
}

