/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gerritchecksapi.rest;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import io.jenkins.plugins.gerritchecksapi.Caching;
import io.jenkins.plugins.gerritchecksapi.CachingCheckRunCollector;
import io.jenkins.plugins.gerritchecksapi.CheckRunCollector;
import io.jenkins.plugins.gerritchecksapi.Direct;
import io.jenkins.plugins.gerritchecksapi.DirectCheckRunCollector;
import io.jenkins.plugins.gerritchecksapi.PermissionAwareCheckRunCollector;
import io.jenkins.plugins.gerritchecksapi.rest.GerritMultiBranchCheckRunFactory;
import io.jenkins.plugins.gerritchecksapi.rest.GerritTriggerCheckRunFactory;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.lucene.search.databackend.SearchBackendManager;

public class PluginGuiceModule
extends AbstractModule {
    protected void configure() {
        this.bind(CheckRunCollector.class).to(PermissionAwareCheckRunCollector.class);
        this.bind(CheckRunCollector.class).annotatedWith(Caching.class).to(CachingCheckRunCollector.class);
        this.bind(CheckRunCollector.class).annotatedWith(Direct.class).to(DirectCheckRunCollector.class);
        this.bind(GerritTriggerCheckRunFactory.class);
        this.bind(GerritMultiBranchCheckRunFactory.class);
    }

    @Provides
    Jenkins getJenkins() {
        return Jenkins.get();
    }

    @Provides
    SearchBackendManager getSearchBackendManager(Jenkins jenkins) {
        return (SearchBackendManager)jenkins.getExtensionList(SearchBackendManager.class).get(0);
    }
}

