/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gerritchecksapi.rest;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import hudson.Extension;
import hudson.model.Job;
import hudson.model.RootAction;
import io.jenkins.plugins.gerritchecksapi.CheckRunCollector;
import io.jenkins.plugins.gerritchecksapi.MissingDependencyException;
import io.jenkins.plugins.gerritchecksapi.PatchSetId;
import io.jenkins.plugins.gerritchecksapi.rest.CheckRun;
import io.jenkins.plugins.gerritchecksapi.rest.CheckRuns;
import io.jenkins.plugins.gerritchecksapi.rest.PluginGuiceModule;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.json.JsonHttpResponse;
import org.kohsuke.stapler.verb.GET;

@Extension
public class GerritChecksRestApi
implements RootAction {
    private final Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new PluginGuiceModule()});
    private final CheckRunCollector checkRunCollector = (CheckRunCollector)this.injector.getInstance(CheckRunCollector.class);

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "gerrit-checks";
    }

    @GET
    @WebMethod(name={"runs"})
    public JsonHttpResponse getCheckRuns(@QueryParameter(required=true) int change, @QueryParameter(required=true) int patchset) {
        CheckRuns result = new CheckRuns();
        try {
            Map<Job<?, ?>, List<CheckRun>> all = this.checkRunCollector.collectFor(PatchSetId.create(change, patchset));
            for (List<CheckRun> runs : all.values()) {
                result.addRuns(runs);
            }
            return new JsonHttpResponse(JSONObject.fromObject((Object)result), 200);
        }
        catch (MissingDependencyException e) {
            return new JsonHttpResponse(JSONObject.fromObject((Object)e.getMessage()), 503);
        }
    }
}

