/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gerritchecksapi.rest;

import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import io.jenkins.plugins.gerritchecksapi.PatchSetId;
import io.jenkins.plugins.gerritchecksapi.rest.Action;
import io.jenkins.plugins.gerritchecksapi.rest.CheckResult;
import io.jenkins.plugins.gerritchecksapi.rest.CheckRun;
import io.jenkins.plugins.gerritchecksapi.rest.Link;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;

public abstract class AbstractCheckRunFactory {
    private final Jenkins jenkins = Jenkins.get();

    public abstract CheckRun create(PatchSetId var1, Job<?, ?> var2, Run<?, ?> var3, int var4);

    protected abstract List<Action> computeActions(Run<?, ?> var1);

    protected static CheckRun.RunStatus computeStatus(Run<?, ?> run) {
        if (run.hasntStartedYet()) {
            return CheckRun.RunStatus.SCHEDULED;
        }
        if (run.isBuilding()) {
            return CheckRun.RunStatus.RUNNING;
        }
        return CheckRun.RunStatus.COMPLETED;
    }

    protected static String computeFinishedTimeStamp(Run<?, ?> run) {
        if (run.hasntStartedYet()) {
            return null;
        }
        long duration = run.isBuilding() ? run.getEstimatedDuration() : run.getDuration();
        return Instant.ofEpochMilli(run.getStartTimeInMillis()).plusMillis(duration).toString();
    }

    protected List<CheckResult> computeCheckResults(Run<?, ?> run) {
        ArrayList<CheckResult> results = new ArrayList<CheckResult>();
        if (run.hasntStartedYet() || run.isBuilding()) {
            return results;
        }
        CheckResult result = new CheckResult();
        result.setExternalId(run.getExternalizableId());
        Result res = run.getResult();
        if (res != null) {
            result.setCategory(CheckResult.Category.fromResult(res));
        }
        result.setLinks(this.computeResultLinks(run));
        results.add(result);
        return results;
    }

    private List<Link> computeResultLinks(Run<?, ?> run) {
        ArrayList<Link> links = new ArrayList<Link>();
        Link consoleLogLink = new Link();
        consoleLogLink.setUrl(String.format("%sconsole", this.getAbsoluteRunUrl(run)));
        consoleLogLink.setTooltip("Build log.");
        consoleLogLink.setIcon(Link.LinkIcon.CODE);
        consoleLogLink.setPrimary(true);
        links.add(consoleLogLink);
        return links;
    }

    protected String getAbsoluteRunUrl(Run<?, ?> run) {
        return String.format("%s%s", this.jenkins.getRootUrl(), run.getUrl());
    }
}

