/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gerritchecksapi;

import java.util.Objects;

public class PatchSetId {
    private final int changeId;
    private final int patchSetNumber;

    public static PatchSetId create(int changeId, int patchSetNumber) {
        return new PatchSetId(changeId, patchSetNumber);
    }

    private PatchSetId(int changeId, int patchSetNumber) {
        this.changeId = changeId;
        this.patchSetNumber = patchSetNumber;
    }

    public int changeId() {
        return this.changeId;
    }

    public int patchSetNumber() {
        return this.patchSetNumber;
    }

    public int hashCode() {
        return Objects.hash(this.changeId, this.patchSetNumber);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PatchSetId) {
            PatchSetId o = (PatchSetId)obj;
            return o.changeId == this.changeId && o.patchSetNumber == this.patchSetNumber;
        }
        return false;
    }

    public String toRef() {
        return String.format("%02d/%d/%d", this.changeId % 100, this.changeId, this.patchSetNumber);
    }
}

