/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gerritchecksapi;

import com.google.gerrit.extensions.restapi.Url;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import hudson.model.Job;
import hudson.model.Run;
import hudson.security.ACL;
import hudson.security.ACLContext;
import io.jenkins.plugins.gerritchecksapi.CheckRunCollector;
import io.jenkins.plugins.gerritchecksapi.MissingDependencyException;
import io.jenkins.plugins.gerritchecksapi.PatchSetId;
import io.jenkins.plugins.gerritchecksapi.rest.CheckRun;
import io.jenkins.plugins.gerritchecksapi.rest.GerritMultiBranchCheckRunFactory;
import io.jenkins.plugins.gerritchecksapi.rest.GerritTriggerCheckRunFactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.apache.log4j.Logger;
import org.jenkinsci.plugins.lucene.search.FreeTextSearchItemImplementation;
import org.jenkinsci.plugins.lucene.search.databackend.SearchBackendManager;
import org.springframework.security.core.Authentication;

@Singleton
public class DirectCheckRunCollector
implements CheckRunCollector {
    private static final Logger LOG = Logger.getLogger(DirectCheckRunCollector.class);
    private final Jenkins jenkins;
    private final Provider<SearchBackendManager> managerProvider;
    private final GerritTriggerCheckRunFactory gerritTriggerCheckRunFactory;
    private final GerritMultiBranchCheckRunFactory gerritMultiBranchCheckRunFactory;

    @Inject
    DirectCheckRunCollector(Jenkins jenkins, Provider<SearchBackendManager> managerProvider, GerritTriggerCheckRunFactory gerritTriggerCheckRunFactory, GerritMultiBranchCheckRunFactory gerritMultiBranchCheckRunFactory) {
        this.jenkins = jenkins;
        this.managerProvider = managerProvider;
        this.gerritTriggerCheckRunFactory = gerritTriggerCheckRunFactory;
        this.gerritMultiBranchCheckRunFactory = gerritMultiBranchCheckRunFactory;
    }

    @Override
    public Map<Job<?, ?>, List<CheckRun>> collectFor(PatchSetId ps) {
        HashMap checkRuns = new HashMap();
        if (this.jenkins.getPlugin("gerrit-trigger") != null) {
            checkRuns.putAll(this.collectGerritTriggerRuns(ps));
        }
        if (this.jenkins.getPlugin("gerrit-code-review") != null) {
            checkRuns.putAll(this.collectGerritMultiBranchRuns(ps));
        }
        return checkRuns;
    }

    private Map<Job<?, ?>, List<CheckRun>> collectGerritTriggerRuns(PatchSetId ps) {
        SearchBackendManager manager = this.getSearchBackendManager();
        try (ACLContext ctx = ACL.as2((Authentication)ACL.SYSTEM2);){
            Map<Job, List<Run>> hits = this.queryRuns(String.format("p:\"refs/changes/%s\"", ps.toRef()), manager).stream().sorted(Comparator.comparing(Run::getNumber)).collect(Collectors.groupingBy(Run::getParent));
            HashMap checkRuns = new HashMap();
            for (Map.Entry<Job, List<Run>> entry : hits.entrySet()) {
                List<Run> runs = entry.getValue();
                ArrayList<CheckRun> checks = new ArrayList<CheckRun>();
                for (int i = 0; i < runs.size(); ++i) {
                    checks.add(this.gerritTriggerCheckRunFactory.create(ps, runs.get(i).getParent(), runs.get(i), i + 1));
                }
                checkRuns.put(entry.getKey(), checks);
            }
            HashMap hashMap = checkRuns;
            return hashMap;
        }
    }

    private Map<Job<?, ?>, List<CheckRun>> collectGerritMultiBranchRuns(PatchSetId ps) {
        SearchBackendManager manager = this.getSearchBackendManager();
        try (ACLContext ctx = ACL.as2((Authentication)ACL.SYSTEM2);){
            Map<Job, List<Run>> runs = this.queryRuns(String.format("j:\"%s\"", DirectCheckRunCollector.convertToUrlEncodedRef(ps)), manager).stream().collect(Collectors.groupingBy(Run::getParent));
            HashMap checkRuns = new HashMap();
            for (Map.Entry<Job, List<Run>> entry : runs.entrySet()) {
                checkRuns.put(entry.getKey(), entry.getValue().stream().map(run -> this.gerritMultiBranchCheckRunFactory.create(ps, (Job<?, ?>)run.getParent(), (Run<?, ?>)run, run.getNumber())).collect(Collectors.toList()));
            }
            HashMap hashMap = checkRuns;
            return hashMap;
        }
    }

    private List<Run> queryRuns(String query, SearchBackendManager manager) {
        ArrayList<Run> foundRuns = new ArrayList<Run>();
        for (FreeTextSearchItemImplementation hit : manager.getHits(query, false)) {
            Job job = (Job)this.jenkins.getItemByFullName(hit.getProjectName(), Job.class);
            if (job == null) {
                throw new IllegalStateException("Couldn't find project returned by index query: " + hit.getProjectName());
            }
            Run run = job.getBuild(hit.getSearchName().split("#")[1]);
            if (run == null) {
                throw new IllegalStateException(String.format("Couldn't find build %s for job %s returned by index query: ", hit.getSearchName(), job.getFullName()));
            }
            LOG.debug((Object)String.format("Found job %s build %s with parent %s", job.getFullName(), run.getNumber(), run.getParent()));
            foundRuns.add(run);
        }
        return foundRuns;
    }

    private SearchBackendManager getSearchBackendManager() {
        SearchBackendManager manager = (SearchBackendManager)this.managerProvider.get();
        if (manager == null) {
            throw new MissingDependencyException(SearchBackendManager.class.getName());
        }
        return manager;
    }

    private static String convertToUrlEncodedRef(PatchSetId ps) {
        return Url.encode((String)ps.toRef());
    }
}

