/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.generic.event.json;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;

public class InstantProcessor
implements JsonValueProcessor {
    public static final String DATE_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ").withZone(ZoneId.systemDefault());

    public Object processArrayValue(Object value, JsonConfig jsonConfig) {
        return value == null ? null : this.formatter.format((Instant)value);
    }

    public Object processObjectValue(String key, Object value, JsonConfig jsonConfig) {
        return this.processArrayValue(value, jsonConfig);
    }
}

