/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.generic.event;

import io.jenkins.plugins.generic.event.Event;
import io.jenkins.plugins.generic.event.EventGlobalConfiguration;
import io.jenkins.plugins.generic.event.EventSender;
import io.jenkins.plugins.generic.event.json.EventJsonConfig;
import io.jenkins.plugins.generic.event.transformer.EventDataTransformers;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import org.apache.commons.lang.StringUtils;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.TimeValue;

public class HttpEventSender
implements EventSender {
    private final Logger logger = Logger.getLogger(HttpEventSender.class.getName());
    private final CustomCloseableHttpAsyncClient myClient = new CustomCloseableHttpAsyncClient();

    @Override
    public void send(final Event event) {
        EventDataTransformers.INSTANCE.transform(event);
        String receiver = EventGlobalConfiguration.get().getReceiver();
        if (StringUtils.isBlank((String)receiver)) {
            this.logger.info("Skipped event sending due to receiver URL not set");
            return;
        }
        try {
            this.myClient.sendPost(receiver, event, new FutureCallback<SimpleHttpResponse>(){

                public void completed(SimpleHttpResponse response) {
                    HttpEventSender.this.logger.info("Event send succeeded, response: " + response.getBodyText() + ", data: " + event.toString());
                }

                public void failed(Exception e) {
                    HttpEventSender.this.logger.info("Event send has been failed, response: " + String.valueOf(e) + ", data: " + event.toString());
                }

                public void cancelled() {
                    HttpEventSender.this.logger.info("Event send has been cancelled");
                }
            });
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Failed to send event to " + receiver, e);
        }
    }

    public static class CustomCloseableHttpAsyncClient {
        private static final CloseableHttpAsyncClient httpClient;
        private static String rootUrl;

        public void sendPost(String receiver, Event event, FutureCallback<SimpleHttpResponse> callback) {
            String eventJSON = JSONObject.fromObject((Object)event, (JsonConfig)new EventJsonConfig()).toString(4);
            SimpleHttpRequest request = SimpleRequestBuilder.post((String)receiver).setBody(eventJSON, ContentType.APPLICATION_JSON).addHeader("X-Event-Type", event.getType()).addHeader("Referrer", rootUrl).build();
            httpClient.execute(request, callback);
        }

        static {
            rootUrl = null;
            TlsStrategy tlsStrategy = ClientTlsStrategyBuilder.create().setSslContext(SSLContexts.createSystemDefault()).setTlsDetailsFactory(sslEngine -> new TlsDetails(sslEngine.getSession(), sslEngine.getApplicationProtocol())).build();
            PoolingAsyncClientConnectionManager cmb = PoolingAsyncClientConnectionManagerBuilder.create().setTlsStrategy(tlsStrategy).setMaxConnPerRoute(1).setMaxConnTotal(1).setConnectionTimeToLive(TimeValue.ofSeconds((long)10L)).build();
            httpClient = HttpAsyncClients.custom().setConnectionManager((AsyncClientConnectionManager)cmb).build();
            httpClient.start();
            Jenkins j = Jenkins.getInstanceOrNull();
            if (j != null) {
                rootUrl = j.getRootUrl();
            }
        }
    }
}

