/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.generic.event;

import hudson.Extension;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest2;

@Extension(ordinal=100.0)
@Symbol(value={"eventDispatcher"})
public class EventGlobalConfiguration
extends GlobalConfiguration {
    private String receiver;
    private String jobNamePatterns;
    private boolean sendRunStarted = true;
    private boolean sendRunCompleted = true;
    private boolean sendRunFinalized = true;
    private boolean sendRunInitialized = true;
    private boolean sendRunDeleted = true;
    private boolean sendItemCreated = true;
    private boolean sendItemDeleted = true;
    private boolean sendItemUpdated = true;
    private boolean sendItemLocationChanged = true;

    public EventGlobalConfiguration() {
        this.load();
    }

    public static EventGlobalConfiguration get() {
        return (EventGlobalConfiguration)((Object)GlobalConfiguration.all().get(EventGlobalConfiguration.class));
    }

    public boolean configure(StaplerRequest2 req, JSONObject json) {
        req.bindJSON((Object)this, json);
        this.save();
        return true;
    }

    public String getDisplayName() {
        return "Event Dispatcher";
    }

    public String getReceiver() {
        return this.receiver;
    }

    @DataBoundSetter
    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    public String getJobNamePatterns() {
        return this.jobNamePatterns;
    }

    @DataBoundSetter
    public void setJobNamePatterns(String jobNamePatterns) {
        this.jobNamePatterns = jobNamePatterns;
    }

    public boolean matchesJobNamePattern(String jobName) {
        String[] patterns;
        if (this.jobNamePatterns == null || this.jobNamePatterns.trim().isEmpty()) {
            return true;
        }
        for (String patternStr : patterns = this.jobNamePatterns.split("\\r?\\n")) {
            if ((patternStr = patternStr.trim()).isEmpty()) continue;
            try {
                Pattern pattern = Pattern.compile(patternStr);
                if (!pattern.matcher(jobName).matches()) continue;
                return true;
            }
            catch (PatternSyntaxException e) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isSendRunStarted() {
        return this.sendRunStarted;
    }

    @DataBoundSetter
    public void setSendRunStarted(boolean sendRunStarted) {
        this.sendRunStarted = sendRunStarted;
    }

    public boolean isSendRunCompleted() {
        return this.sendRunCompleted;
    }

    @DataBoundSetter
    public void setSendRunCompleted(boolean sendRunCompleted) {
        this.sendRunCompleted = sendRunCompleted;
    }

    public boolean isSendRunFinalized() {
        return this.sendRunFinalized;
    }

    @DataBoundSetter
    public void setSendRunFinalized(boolean sendRunFinalized) {
        this.sendRunFinalized = sendRunFinalized;
    }

    public boolean isSendRunInitialized() {
        return this.sendRunInitialized;
    }

    @DataBoundSetter
    public void setSendRunInitialized(boolean sendRunInitialized) {
        this.sendRunInitialized = sendRunInitialized;
    }

    public boolean isSendRunDeleted() {
        return this.sendRunDeleted;
    }

    @DataBoundSetter
    public void setSendRunDeleted(boolean sendRunDeleted) {
        this.sendRunDeleted = sendRunDeleted;
    }

    public boolean isSendItemCreated() {
        return this.sendItemCreated;
    }

    @DataBoundSetter
    public void setSendItemCreated(boolean sendItemCreated) {
        this.sendItemCreated = sendItemCreated;
    }

    public boolean isSendItemDeleted() {
        return this.sendItemDeleted;
    }

    @DataBoundSetter
    public void setSendItemDeleted(boolean sendItemDeleted) {
        this.sendItemDeleted = sendItemDeleted;
    }

    public boolean isSendItemUpdated() {
        return this.sendItemUpdated;
    }

    @DataBoundSetter
    public void setSendItemUpdated(boolean sendItemUpdated) {
        this.sendItemUpdated = sendItemUpdated;
    }

    public boolean isSendItemLocationChanged() {
        return this.sendItemLocationChanged;
    }

    @DataBoundSetter
    public void setSendItemLocationChanged(boolean sendItemLocationChanged) {
        this.sendItemLocationChanged = sendItemLocationChanged;
    }
}

