/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.finitestate;

import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;

public class CLTManager {
    private static final String CLT_FILENAME_PREFIX = "finitestate-clt";
    private static final String CLT_FILENAME_SUFFIX = ".jar";
    private static final String USER_AGENT = "FiniteState-Jenkins-Plugin/1.0";

    private CLTManager() {
    }

    private static String getCLTFilename(String subdomain) {
        return "finitestate-clt-" + subdomain + CLT_FILENAME_SUFFIX;
    }

    public static FilePath getOrDownloadCLT(String cltUrl, String apiToken, String subdomain, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        String filename = CLTManager.getCLTFilename(subdomain);
        FilePath cltPath = workspace.child(filename);
        if (cltPath.exists() && cltPath.length() > 0L) {
            listener.getLogger().println("CLT already exists at: " + cltPath.getRemote());
            return cltPath;
        }
        listener.getLogger().println("CLT not found, downloading from: " + cltUrl);
        return CLTManager.downloadCLT(cltUrl, apiToken, subdomain, cltPath, listener);
    }

    private static boolean testJarFile(FilePath jarPath, TaskListener listener) throws IOException, InterruptedException {
        try (InputStream is = jarPath.read();){
            boolean looksLikeZip;
            byte[] header = new byte[4];
            int read = is.read(header);
            boolean bl = looksLikeZip = read == 4 && header[0] == 80 && header[1] == 75;
            if (looksLikeZip) {
                listener.getLogger().println("JAR file header verified successfully");
            } else {
                listener.getLogger().println("WARNING: File does not appear to be a valid JAR file");
            }
            boolean bl2 = looksLikeZip;
            return bl2;
        }
    }

    private static FilePath downloadCLT(String url, String apiToken, String subdomain, FilePath cltPath, TaskListener listener) throws IOException, InterruptedException {
        listener.getLogger().println("Downloading CLT from: " + url);
        URLConnection connection = new URL(url).openConnection();
        connection.setRequestProperty("X-Authorization", apiToken);
        connection.setRequestProperty("User-Agent", USER_AGENT);
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection httpConnection = (HttpURLConnection)connection;
            int responseCode = httpConnection.getResponseCode();
            listener.getLogger().println("HTTP Response Code: " + responseCode);
            if (responseCode != 200) {
                Object errorMessage;
                block35: {
                    errorMessage = "Failed to download CLT. HTTP Response: " + responseCode;
                    if (responseCode == 401) {
                        errorMessage = "Authentication failed (HTTP 401). Please check your API token and ensure it is valid for the specified subdomain.";
                    } else if (responseCode == 403) {
                        errorMessage = "Access denied (HTTP 403). Please check your API token permissions.";
                    } else if (responseCode == 404) {
                        errorMessage = "CLT not found (HTTP 404). Please check the subdomain configuration.";
                    } else if (responseCode >= 500) {
                        errorMessage = "Server error (HTTP " + responseCode + "). Please try again later or contact support.";
                    }
                    try {
                        InputStream errorStream = httpConnection.getErrorStream();
                        if (errorStream == null) break block35;
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(errorStream, StandardCharsets.UTF_8));){
                            String line;
                            StringBuilder errorResponse = new StringBuilder();
                            while ((line = reader.readLine()) != null) {
                                errorResponse.append(line).append("\n");
                            }
                            if (errorResponse.length() > 0) {
                                errorMessage = (String)errorMessage + "\nError Response: " + errorResponse.toString();
                            }
                        }
                    }
                    catch (Exception e) {
                        listener.getLogger().println("Warning: Could not read error response details: " + e.getMessage());
                    }
                }
                throw new IOException((String)errorMessage);
            }
        }
        long totalBytes = 0L;
        try (InputStream in = connection.getInputStream();
             OutputStream out = cltPath.write();){
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                totalBytes += (long)bytesRead;
            }
        }
        if (!cltPath.exists()) {
            throw new IOException("Downloaded file does not exist");
        }
        if (cltPath.length() == 0L) {
            throw new IOException("Downloaded file is empty");
        }
        listener.getLogger().println("Downloaded " + totalBytes + " bytes to: " + cltPath.getRemote());
        listener.getLogger().println("File size: " + cltPath.length() + " bytes");
        CLTManager.testJarFile(cltPath, listener);
        try {
            cltPath.chmod(493);
        }
        catch (Exception exception) {
            // empty catch block
        }
        listener.getLogger().println("CLT downloaded successfully to: " + cltPath.getRemote());
        return cltPath;
    }
}

