/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.eggplant.utils;

import hudson.FilePath;
import io.jenkins.plugins.eggplant.common.OperatingSystem;
import io.jenkins.plugins.eggplant.exception.BuilderException;
import io.jenkins.plugins.eggplant.exception.InvalidRunnerException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jenkins.model.Jenkins;

public class CLIRunnerHelper {
    private static final String CLI_VERSION = "25.3.0+1";
    private static final Map<OperatingSystem, String> CLI_FILENAME = Stream.of(new AbstractMap.SimpleEntry<OperatingSystem, String>(OperatingSystem.LINUX, "eggplant-runner-Linux-${cliVersion}"), new AbstractMap.SimpleEntry<OperatingSystem, String>(OperatingSystem.MACOS, "eggplant-runner-MacOS-${cliVersion}"), new AbstractMap.SimpleEntry<OperatingSystem, String>(OperatingSystem.WINDOWS, "eggplant-runner-Windows-${cliVersion}.exe")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    private static final String CLI_DOWNLOAD_URL = "https://assets.eggplantsoftware.com/EggplantRunner/${cliFilename}";
    private static final String CLI_ENG_DOWNLOAD_URL = "https://gitlab.com/api/v4/projects/22402994/packages/generic/${cliVersion}/0.0.0/${cliFilename}";
    private PrintStream logger;
    private FilePath workspace;
    private String cliFilename;
    private FilePath cliFilePath;

    public CLIRunnerHelper(FilePath workspace, OperatingSystem os, PrintStream logger) {
        this.workspace = workspace;
        this.cliFilename = CLI_FILENAME.get((Object)os).replace("${cliVersion}", CLI_VERSION.toLowerCase());
        this.cliFilePath = workspace.child("downloads").child(this.cliFilename);
        this.logger = logger;
    }

    public FilePath getFilePath() {
        return this.cliFilePath;
    }

    public String getFilename() {
        return this.cliFilename;
    }

    public String getPublicDownloadLink() {
        return CLI_DOWNLOAD_URL.replace("${cliFilename}", this.cliFilename);
    }

    public void copyRunnerFrom(String path) throws IOException, InterruptedException {
        this.logger.println(">> Checking runner...");
        FilePath filePath = this.CLIValidation(path);
        this.logger.println("Fetching runner from " + path);
        this.cliFilePath.copyFrom(filePath);
        this.logger.println("Fetch complete.");
    }

    public FilePath CLIValidation(String path) throws IOException {
        File file = new File(path);
        if (!file.canRead()) {
            throw new InvalidRunnerException("No such file or permission denied. Eggplant Runner Path: " + path);
        }
        if (file.isDirectory()) {
            throw new InvalidRunnerException("Path provided must not be a directory. Eggplant Runner Path: " + path);
        }
        FilePath filePath = new FilePath(file);
        String filePathMinor = "";
        String cliFilenameMinor = "";
        String fileName = filePath.getName();
        String pattern = "eggplant-runner-(Windows|Linux|MacOS)-(\\d{1,2}\\.\\d)";
        Pattern compiledPattern = Pattern.compile(pattern);
        Matcher matcherCLI = compiledPattern.matcher(this.cliFilename);
        Matcher matcherFilePath = compiledPattern.matcher(fileName);
        cliFilenameMinor = matcherCLI.find() ? matcherCLI.group(0) : "not correct file format";
        filePathMinor = matcherFilePath.find() ? matcherFilePath.group(0) : "not match";
        if (!filePathMinor.equals(cliFilenameMinor)) {
            throw new InvalidRunnerException("File found is invalid. Required: " + this.cliFilename + ". Please download from " + this.getPublicDownloadLink());
        }
        return filePath;
    }

    public void downloadRunner(String gitlabAccessToken) throws IOException, InterruptedException {
        String cliDownloadUrl = this.getPublicDownloadLink();
        HashMap<String, String> properties = new HashMap<String, String>();
        this.logger.println(">> Downloading runner...");
        if (gitlabAccessToken == null) {
            FilePath defaultCache = this.workspace.child("downloads").child(this.cliFilename);
            if (defaultCache.exists()) {
                this.logger.println("Runner found in default directory, skipping download.");
                return;
            }
        } else {
            cliDownloadUrl = CLI_ENG_DOWNLOAD_URL.replace("${cliVersion}", CLI_VERSION).replace("${cliFilename}", this.cliFilename);
            properties.put("PRIVATE-TOKEN", gitlabAccessToken);
            this.cliFilePath = this.workspace.child("downloads").child("eng").child(this.cliFilename);
        }
        this.downloadFromUrl(cliDownloadUrl, properties);
    }

    public Proxy setProxy(final String ip, final int port, final String username, final String password) {
        Authenticator.setDefault(new Authenticator(){

            @Override
            public PasswordAuthentication getPasswordAuthentication() {
                if (this.getRequestorType() == Authenticator.RequestorType.PROXY && this.getRequestingHost().equalsIgnoreCase(ip) && port == this.getRequestingPort()) {
                    return new PasswordAuthentication(username, password.toCharArray());
                }
                return null;
            }
        });
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(ip, port));
    }

    private FilePath downloadFromUrl(String url, Map<String, String> properties) throws BuilderException {
        try {
            this.logger.println("GET " + url);
            HttpURLConnection connection = null;
            if (Jenkins.get().proxy != null) {
                String proxyHostname = Jenkins.get().proxy.name;
                int n = Jenkins.get().proxy.port;
                String proxyUsername = Jenkins.get().proxy.getUserName();
                String proxyPassword = Jenkins.get().proxy.getSecretPassword().getPlainText();
                Proxy proxy = this.setProxy(proxyHostname, n, proxyUsername, proxyPassword);
                this.logger.println("Connected through proxy server.");
                connection = (HttpURLConnection)new URL(url).openConnection(proxy);
            } else {
                connection = (HttpURLConnection)new URL(url).openConnection();
            }
            for (Map.Entry entry : properties.entrySet()) {
                connection.addRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
            connection.setDoOutput(true);
            connection.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36");
            InputStream in = connection.getInputStream();
            this.cliFilePath.copyFrom(in);
            this.logger.println("Download successfully.");
        }
        catch (Exception e) {
            throw new BuilderException("Download failed. Unable to download from url: " + url + ". Error details:" + e.toString());
        }
        return this.cliFilePath;
    }
}

