/*
 * Decompiled with CFR 0.152.
 */
package io.superstudios.plugins.diversion;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import hudson.util.ListBoxModel;
import io.superstudios.plugins.diversion.DiversionApiClient;
import io.superstudios.plugins.diversion.DiversionBranch;
import io.superstudios.plugins.diversion.DiversionFile;
import io.superstudios.plugins.diversion.DiversionRepository;
import io.superstudios.plugins.diversion.DiversionSCM;
import io.superstudios.plugins.diversion.DiversionSCMFileSystem;
import io.superstudios.plugins.diversion.DiversionSCMHead;
import io.superstudios.plugins.diversion.DiversionSCMRevision;
import io.superstudios.plugins.diversion.DiversionUIHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceDescriptor;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class DiversionSCMSource
extends SCMSource {
    private final String repositoryId;
    private final String credentialsId;
    private String libraryPath = "vars";
    private String defaultBranch = "dev";

    @DataBoundConstructor
    public DiversionSCMSource(String repositoryId, String credentialsId) {
        this.repositoryId = repositoryId;
        this.credentialsId = credentialsId;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getLibraryPath() {
        return this.libraryPath;
    }

    @DataBoundSetter
    public void setLibraryPath(String libraryPath) {
        this.libraryPath = libraryPath;
    }

    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    @DataBoundSetter
    public void setDefaultBranch(String defaultBranch) {
        this.defaultBranch = defaultBranch;
    }

    @NonNull
    public SCMRevision retrieve(@NonNull String version, @NonNull TaskListener listener) throws IOException, InterruptedException {
        listener.getLogger().println("Retrieving Diversion revision: " + version);
        String branchId = version.startsWith("dv.branch.") ? version : this.defaultBranch;
        DiversionApiClient client = new DiversionApiClient(this.credentialsId);
        DiversionBranch branch = client.getBranchDetails(this.repositoryId, branchId);
        DiversionSCMHead head = new DiversionSCMHead(branch.getBranchName(), branch.getBranchId());
        String commitId = branch.getCommitId();
        listener.getLogger().println("Branch: " + branch.getBranchName() + " at commit: " + commitId);
        return new DiversionSCMRevision(head, commitId != null ? commitId : "HEAD");
    }

    @CheckForNull
    protected SCMRevision retrieve(@NonNull SCMHead head, @NonNull TaskListener listener) throws IOException, InterruptedException {
        listener.getLogger().println("Retrieving revision for branch: " + head.getName());
        DiversionApiClient client = new DiversionApiClient(this.credentialsId);
        DiversionSCMHead diversionHead = (DiversionSCMHead)head;
        try {
            DiversionBranch branch = client.getBranchDetails(this.repositoryId, diversionHead.getBranchId());
            String commitId = branch.getCommitId();
            if (commitId != null && !commitId.isEmpty()) {
                listener.getLogger().println("Current commit: " + commitId);
                return new DiversionSCMRevision(head, commitId);
            }
        }
        catch (Exception e) {
            listener.getLogger().println("Failed to retrieve revision: " + e.getMessage());
        }
        return null;
    }

    protected void retrieve(@CheckForNull SCMSourceCriteria criteria, @NonNull SCMHeadObserver observer, @CheckForNull SCMHeadEvent<?> event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        listener.getLogger().println("Discovering branches in Diversion repository: " + this.repositoryId);
        DiversionApiClient client = new DiversionApiClient(this.credentialsId);
        try {
            SCMFile root;
            DiversionSCMFileSystem fs;
            DiversionRepository repo = client.getRepository(this.repositoryId);
            listener.getLogger().println("Repository: " + repo.getName());
            String branchId = client.resolveBranchId(this.repositoryId, this.defaultBranch);
            listener.getLogger().println("Using branch: " + this.defaultBranch + " (ID: " + branchId + ")");
            final DiversionSCMHead head = new DiversionSCMHead(this.defaultBranch, branchId);
            DiversionBranch branch = client.getBranchDetails(this.repositoryId, branchId);
            DiversionSCMRevision revision = new DiversionSCMRevision(head, branch.getCommitId());
            if (criteria != null && (fs = new DiversionSCMFileSystem(this.repositoryId, branchId, this.credentialsId, this.libraryPath, revision)) != null && !criteria.isHead(new SCMSourceCriteria.Probe(root = fs.getRoot()){
                final /* synthetic */ SCMFile val$root;
                {
                    this.val$root = sCMFile;
                }

                public String name() {
                    return head.getName();
                }

                public long lastModified() {
                    return 0L;
                }

                public boolean exists(@NonNull String path) throws IOException {
                    try {
                        SCMFile file = this.val$root.child(path);
                        return file.isFile() || file.isDirectory();
                    }
                    catch (InterruptedException e) {
                        throw new IOException(e);
                    }
                }
            }, listener)) {
                listener.getLogger().println("Branch does not meet criteria");
                return;
            }
            observer.observe((SCMHead)head, (SCMRevision)revision);
            listener.getLogger().println("Branch discovery completed");
        }
        catch (Exception e) {
            listener.getLogger().println("Error during branch discovery: " + e.getMessage());
            e.printStackTrace(listener.getLogger());
            throw new IOException("Failed to discover branches: " + e.getMessage(), e);
        }
    }

    @NonNull
    public SCM build(@NonNull SCMHead head, @CheckForNull SCMRevision revision) {
        if (!(head instanceof DiversionSCMHead)) {
            throw new IllegalArgumentException("Expected DiversionSCMHead, got " + head.getClass().getName());
        }
        DiversionSCM scm = new DiversionSCM(this.repositoryId, this.credentialsId);
        scm.setBranch(((DiversionSCMHead)head).getBranchId());
        scm.setLibraryPath(this.libraryPath);
        return scm;
    }

    @Symbol(value={"diversionSource", "diversion"})
    @Extension
    public static class DescriptorImpl
    extends SCMSourceDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Diversion";
        }

        @NonNull
        public String getId() {
            return "io.superstudios.plugins.diversion.DiversionSCMSource";
        }

        @RequirePOST
        public ListBoxModel doFillRepositoryIdItems(@AncestorInPath Item context, @QueryParameter String credentialsId) {
            if (context == null ? !Jenkins.get().hasPermission(Jenkins.MANAGE) : !context.hasPermission(CredentialsProvider.USE_ITEM)) {
                return new ListBoxModel();
            }
            return DiversionUIHelper.fillRepositoryIdItems(credentialsId, "Error loading repositories");
        }

        @RequirePOST
        public ListBoxModel doFillDefaultBranchItems(@AncestorInPath Item context, @QueryParameter String credentialsId, @QueryParameter String repositoryId) {
            if (context == null ? !Jenkins.get().hasPermission(Jenkins.MANAGE) : !context.hasPermission(CredentialsProvider.USE_ITEM)) {
                return new ListBoxModel();
            }
            return DiversionUIHelper.fillBranchItems(credentialsId, repositoryId, "Error loading branches");
        }

        @RequirePOST
        public ListBoxModel doFillLibraryPathItems(@AncestorInPath Item context, @QueryParameter String credentialsId, @QueryParameter String repositoryId, @QueryParameter String defaultBranch, @QueryParameter String libraryPath) {
            if (context == null ? !Jenkins.get().hasPermission(Jenkins.MANAGE) : !context.hasPermission(CredentialsProvider.USE_ITEM)) {
                return new ListBoxModel();
            }
            ListBoxModel items = new ListBoxModel();
            if (libraryPath != null && !libraryPath.isEmpty()) {
                items.add(libraryPath, libraryPath);
            }
            items.add("Root (vars/ at repository root)", "");
            if (!(credentialsId == null || credentialsId.isEmpty() || repositoryId == null || repositoryId.isEmpty() || defaultBranch == null || defaultBranch.isEmpty())) {
                try {
                    DiversionApiClient client = new DiversionApiClient(credentialsId);
                    List<DiversionFile> files = client.getFileTree(repositoryId, defaultBranch);
                    HashSet<String> varsParents = new HashSet<String>();
                    boolean hasRootVars = false;
                    for (DiversionFile file : files) {
                        String path = file.getPath();
                        if (!path.contains("/vars/") || !path.endsWith(".groovy")) continue;
                        int varsIndex = path.indexOf("/vars/");
                        if (varsIndex > 0) {
                            String parent = path.substring(0, varsIndex);
                            varsParents.add(parent);
                            continue;
                        }
                        if (varsIndex != 0) continue;
                        hasRootVars = true;
                    }
                    if (!varsParents.isEmpty() || hasRootVars) {
                        items.add("- Detected Library Paths -", "");
                        if (hasRootVars) {
                            items.add("\ud83d\udcda Repository Root (vars/ at root)", "");
                        }
                        ArrayList sortedPaths = new ArrayList(varsParents);
                        Collections.sort(sortedPaths);
                        for (String path : sortedPaths) {
                            items.add("\ud83d\udcda " + path, path);
                        }
                    }
                }
                catch (Exception e) {
                    items.add("(Could not load directories: " + e.getMessage() + ")", "");
                }
            }
            return items;
        }

        @RequirePOST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @QueryParameter String credentialsId) {
            return DiversionUIHelper.fillCredentialsIdItems(context, credentialsId);
        }
    }
}

