/*
 * Decompiled with CFR 0.152.
 */
package io.superstudios.plugins.diversion;

import com.fasterxml.jackson.databind.JsonNode;

public class DiversionFile {
    private String path;
    private String type;
    private String blobId;
    private long size;

    public DiversionFile() {
    }

    public DiversionFile(JsonNode json) {
        this.path = json.get("path").asText();
        this.type = json.get("type").asText();
        this.blobId = json.has("blobId") ? json.get("blobId").asText() : null;
        this.size = json.has("size") ? json.get("size").asLong() : 0L;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setBlobId(String blobId) {
        this.blobId = blobId;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getPath() {
        return this.path;
    }

    public String getType() {
        return this.type;
    }

    public String getBlobId() {
        return this.blobId;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isFile() {
        return "blob".equals(this.type);
    }

    public boolean isDirectory() {
        return "tree".equals(this.type);
    }

    public String toString() {
        return "DiversionFile{path='" + this.path + "', type='" + this.type + "', blobId='" + this.blobId + "', size=" + this.size + "}";
    }
}

