/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.customizable_header.logo;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.FormValidation;
import io.jenkins.plugins.customizable_header.HeaderRootAction;
import io.jenkins.plugins.customizable_header.RemoteAssetCache;
import io.jenkins.plugins.customizable_header.logo.Logo;
import io.jenkins.plugins.customizable_header.logo.LogoDescriptor;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.POST;

public class ImageLogo
extends Logo {
    private String logoUrl;

    @DataBoundConstructor
    public ImageLogo(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public String getLogoUrl() {
        return this.logoUrl;
    }

    public String getUrl() {
        return this.proxiedUrl(this.logoUrl);
    }

    private String proxiedUrl(String remoteUrl) {
        StaplerRequest2 req = Stapler.getCurrentRequest2();
        Object rootUrl = req != null ? req.getContextPath() + "/" : Jenkins.get().getRootUrl();
        RemoteAssetCache.addUrlToCache(remoteUrl);
        String enc = URLEncoder.encode(remoteUrl, StandardCharsets.UTF_8);
        return (String)rootUrl + "customizable-header/fetch?u=" + enc;
    }

    @Extension
    @Symbol(value={"image"})
    public static class DescriptorImpl
    extends LogoDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Image";
        }

        @POST
        public FormValidation doCheckLogoUrl(@QueryParameter String value) throws Exception {
            if (value == null || value.isBlank()) {
                return FormValidation.error((String)"Logo URL must not be empty");
            }
            try {
                URI uri = new URI(value);
                if (!uri.isAbsolute()) {
                    Path filePath = HeaderRootAction.resolvePath(value);
                    if (HeaderRootAction.isNotValidPath(filePath)) {
                        return FormValidation.error((String)"Relative path must be within the \"userContent\" directory under \"JENKINS_HOME\"");
                    }
                } else {
                    String scheme = uri.getScheme();
                    if (!scheme.equals("http") && !scheme.equals("https")) {
                        return FormValidation.error((String)"Only HTTP and HTTPS URLs are supported");
                    }
                }
                return FormValidation.ok();
            }
            catch (URISyntaxException e) {
                return FormValidation.error((String)("Invalid URL: " + e.getMessage()));
            }
        }
    }
}

