/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.customizable_header;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.FolderIcon;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.HealthReport;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.User;
import hudson.model.labels.LabelAtom;
import hudson.model.labels.LabelExpression;
import io.jenkins.plugins.customizable_header.logo.Icon;
import io.jenkins.plugins.customizable_header.logo.ImageLogo;
import io.jenkins.plugins.customizable_header.logo.Logo;
import io.jenkins.plugins.customizable_header.logo.SvgLogo;
import io.jenkins.plugins.customizable_header.logo.Symbol;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.Stapler;

public class ContextAwareLogo
implements Describable<ContextAwareLogo> {
    private boolean showJobWeather;
    private boolean showFolderWeather;
    private String symbolMappingFile;
    private transient Properties customMapping;
    private transient long lastModified;
    private transient String mappingFile;
    private static final Logger LOGGER = Logger.getLogger(ContextAwareLogo.class.getName());
    private static final Map<String, Logo> defaultLogoMapping = new HashMap<String, Logo>();
    private static final List<String> knownPathes = new ArrayList<String>();

    @DataBoundConstructor
    public ContextAwareLogo() {
    }

    public boolean getShowJobWeather() {
        return this.showJobWeather;
    }

    @DataBoundSetter
    public void setShowJobWeather(boolean showJobWeather) {
        this.showJobWeather = showJobWeather;
    }

    public boolean getShowFolderWeather() {
        return this.showFolderWeather;
    }

    @DataBoundSetter
    public void setShowFolderWeather(boolean showFolderWeather) {
        this.showFolderWeather = showFolderWeather;
    }

    @DataBoundSetter
    public void setSymbolMappingFile(String symbolMappingFile) {
        this.symbolMappingFile = symbolMappingFile;
        this.lastModified = 0L;
    }

    public String getSymbolMappingFile() {
        return this.symbolMappingFile;
    }

    private void updateMappingFile() {
        if (Util.fixEmptyAndTrim((String)this.symbolMappingFile) != null) {
            File file = new File(this.symbolMappingFile);
            if (!file.isAbsolute()) {
                file = new File(Jenkins.get().getRootDir(), this.symbolMappingFile);
            }
            this.mappingFile = file.isFile() ? file.getAbsolutePath() : null;
        } else {
            this.mappingFile = null;
        }
        this.lastModified = -1L;
    }

    @Restricted(value={NoExternalUse.class})
    public Properties getSymbolMapping() {
        File file;
        if (this.customMapping == null) {
            this.customMapping = new Properties();
        }
        if (this.lastModified == 0L) {
            this.updateMappingFile();
        }
        if (this.mappingFile != null && (file = new File(this.mappingFile)).lastModified() != this.lastModified) {
            this.lastModified = file.lastModified();
            try (FileReader reader = new FileReader(file, StandardCharsets.UTF_8);){
                this.customMapping.clear();
                this.customMapping.load(reader);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to read custom mapping.", e);
            }
        }
        return this.customMapping;
    }

    public Logo getLogo() {
        ArrayList ancestors = new ArrayList(Stapler.getCurrentRequest2().getAncestors());
        Collections.reverse(ancestors);
        for (Ancestor ancestor : ancestors) {
            Action action;
            String iconFileName;
            HealthReport health;
            Object obj = ancestor.getObject();
            LOGGER.log(Level.FINE, "Context: {0}", obj.getClass().getName());
            if (obj instanceof Run) {
                Run run = (Run)obj;
                return defaultLogoMapping.get(run.getBuildStatusIconClassName());
            }
            if (obj instanceof Job) {
                Job job = (Job)obj;
                if (this.showJobWeather) {
                    health = job.getBuildHealth();
                    return this.getLogoOrDefault(health.getIconClassName());
                }
                return defaultLogoMapping.get(job.getBuildStatusIconClassName());
            }
            if (obj instanceof AbstractFolder) {
                AbstractFolder folder = (AbstractFolder)obj;
                if (this.showFolderWeather) {
                    health = folder.getBuildHealth();
                    return this.getLogoOrDefault(health.getIconClassName());
                }
                FolderIcon fIcon = folder.getIcon();
                String folderIconName = fIcon.getIconClassName();
                if (folderIconName == null) {
                    folderIconName = fIcon.getImageOf("32x32");
                    if (folderIconName.startsWith(Stapler.getCurrentRequest2().getContextPath())) {
                        folderIconName = folderIconName.substring(Stapler.getCurrentRequest2().getContextPath().length());
                    }
                    return new ImageLogo(folderIconName);
                }
                if (folderIconName.startsWith("icon-")) {
                    return new Icon(folderIconName);
                }
                if (folderIconName.startsWith("symbol-")) {
                    return new Symbol(folderIconName);
                }
                return new Symbol("symbol-folder-outline plugin-ionicons-api");
            }
            if (obj instanceof Computer) {
                Computer computer = (Computer)obj;
                Logo logo = this.handleComputerUrl("hudson.model.Computer");
                return Objects.requireNonNullElseGet(logo, () -> new Symbol(computer.getIconClassName()));
            }
            if (obj instanceof LabelAtom || obj instanceof LabelExpression) {
                return new Symbol("symbol-pricetag-outline");
            }
            if (obj instanceof Action && (iconFileName = (action = (Action)obj).getIconFileName()) != null && iconFileName.startsWith("symbol-")) {
                return new Symbol(iconFileName);
            }
            Logo logo = this.getLogoOrDefault(obj.getClass().getName());
            if (logo != null) {
                return logo;
            }
            if (!(obj instanceof Hudson) || (logo = this.handleComputerUrl("hudson.model.Hudson")) == null) continue;
            return logo;
        }
        return null;
    }

    private Logo handleComputerUrl(String context) {
        String path = Stapler.getCurrentRequest2().getPathInfo();
        if (knownPathes.contains(path = path.substring(path.lastIndexOf(47)))) {
            return this.getLogoOrDefault(context + path);
        }
        return null;
    }

    private Logo getLogoOrDefault(String mapping) {
        String symbol = this.translateSymbol(mapping);
        if (symbol != null) {
            return this.getTranslatedLogo(symbol);
        }
        return defaultLogoMapping.get(mapping);
    }

    private Logo getTranslatedLogo(String name) {
        if (name.startsWith("file-")) {
            return new SvgLogo(name.substring(5), true);
        }
        return new Symbol(name);
    }

    @CheckForNull
    private String translateSymbol(String name) {
        return this.getSymbolMapping().getProperty(name);
    }

    static {
        knownPathes.add("/script");
        knownPathes.add("/systemInfo");
        knownPathes.add("/builds");
        knownPathes.add("/log");
        knownPathes.add("/load-statistics");
        defaultLogoMapping.put("hudson.LocalPluginManager", new Symbol("symbol-extension-puzzle-outline"));
        defaultLogoMapping.put("hudson.model.ComputerSet", new Symbol("symbol-computer"));
        defaultLogoMapping.put("jenkins.agents.CloudSet", new Symbol("symbol-cloud-outline"));
        defaultLogoMapping.put("hudson.cli.CLIAction", new Symbol("symbol-terminal-outline"));
        defaultLogoMapping.put("hudson.diagnosis.OldDataMonitor", new Symbol("symbol-trash-bin-outline"));
        defaultLogoMapping.put("jenkins.management.ShutdownLink", new Symbol("symbol-power-outline"));
        defaultLogoMapping.put("hudson.logging.LogRecorderManager", new Symbol("symbol-journal-outline"));
        defaultLogoMapping.put("hudson.AboutJenkins", new Symbol("symbol-jenkins"));
        defaultLogoMapping.put("hudson.model.User", new Symbol("symbol-person"));
        defaultLogoMapping.put("hudson.security.HudsonPrivateSecurityRealm", new Symbol("symbol-people-outline"));
        defaultLogoMapping.put("org.jenkinsci.plugins.configfiles.ConfigFilesManagement", new Symbol("symbol-cfg-logo plugin-config-file-provider"));
        defaultLogoMapping.put("com.cloudbees.plugins.credentials.ViewCredentialsAction$RootActionImpl", new Symbol("symbol-id-card-outline"));
        defaultLogoMapping.put("org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval", new Symbol("symbol-document-text-outline"));
        defaultLogoMapping.put("hudson.model.Hudson/script", new Symbol("symbol-code-working-outline"));
        defaultLogoMapping.put("hudson.model.Hudson/systemInfo", new Symbol("symbol-server-outline"));
        defaultLogoMapping.put("hudson.model.Hudson/load-statistics", new Symbol("symbol-analytics-outline"));
        defaultLogoMapping.put("hudson.model.Hudson/builds", new Symbol("symbol-file-tray-full-outline"));
        defaultLogoMapping.put("hudson.model.Computer/script", new Symbol("symbol-code-working-outline"));
        defaultLogoMapping.put("hudson.model.Computer/systemInfo", new Symbol("symbol-server-outline"));
        defaultLogoMapping.put("hudson.model.Computer/load-statistics", new Symbol("symbol-analytics-outline"));
        defaultLogoMapping.put("hudson.model.Computer/builds", new Symbol("symbol-file-tray-full-outline"));
        defaultLogoMapping.put("hudson.model.Computer/log", new Symbol("symbol-clipboard-outline"));
        defaultLogoMapping.put("icon-aborted", new Symbol("symbol-status-aborted"));
        defaultLogoMapping.put("icon-aborted-anime", new Symbol("symbol-status-aborted-anime"));
        defaultLogoMapping.put("icon-blue", new Symbol("symbol-status-blue"));
        defaultLogoMapping.put("icon-blue-anime", new Symbol("symbol-status-blue-anime"));
        defaultLogoMapping.put("icon-disabled", new Symbol("symbol-status-disabled"));
        defaultLogoMapping.put("icon-disabled-anime", new Symbol("symbol-status-disabled-anime"));
        defaultLogoMapping.put("icon-nobuilt", new Symbol("symbol-status-nobuilt"));
        defaultLogoMapping.put("icon-nobuilt-anime", new Symbol("symbol-status-nobuilt-anime"));
        defaultLogoMapping.put("icon-red", new Symbol("symbol-status-red"));
        defaultLogoMapping.put("icon-red-anime", new Symbol("symbol-status-red-anime"));
        defaultLogoMapping.put("icon-yellow", new Symbol("symbol-status-yellow"));
        defaultLogoMapping.put("icon-yellow-anime", new Symbol("symbol-status-yellow-anime"));
        defaultLogoMapping.put("icon-health-80plus", new Symbol("symbol-weather-icon-health-80plus plugin-core"));
        defaultLogoMapping.put("icon-health-00to19", new Symbol("symbol-weather-icon-health-00to19 plugin-core"));
        defaultLogoMapping.put("icon-health-20to39", new Symbol("symbol-weather-icon-health-20to39 plugin-core"));
        defaultLogoMapping.put("icon-health-40to59", new Symbol("symbol-weather-icon-health-40to59 plugin-core"));
        defaultLogoMapping.put("icon-health-60to79", new Symbol("symbol-weather-icon-health-60to79 plugin-core"));
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ContextAwareLogo> {
        @NonNull
        public String getDisplayName() {
            return "";
        }

        public boolean isRoot() {
            ArrayList ancestors = new ArrayList(Stapler.getCurrentRequest2().getAncestors());
            return ancestors.stream().noneMatch(it -> it.getObject() instanceof User);
        }
    }
}

