/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.view.calendar.service;

import hudson.model.Job;
import hudson.scheduler.CronTab;
import hudson.scheduler.CronTabList;
import hudson.scheduler.Hash;
import hudson.triggers.SCMTrigger;
import hudson.triggers.Trigger;
import io.jenkins.plugins.extended_timer_trigger.CronTabWrapper;
import io.jenkins.plugins.extended_timer_trigger.ExtendedTimerTrigger;
import io.jenkins.plugins.view.calendar.CalendarView;
import io.jenkins.plugins.view.calendar.service.CronWrapper;
import io.jenkins.plugins.view.calendar.time.Moment;
import io.jenkins.plugins.view.calendar.util.PluginUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.triggers.TriggeredItem;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jenkinsci.plugins.parameterizedscheduler.ParameterizedCronTab;
import org.jenkinsci.plugins.parameterizedscheduler.ParameterizedTimerTrigger;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class CronJobService {
    private final transient Moment now;

    public CronJobService() {
        this(new Moment());
    }

    public CronJobService(Moment now) {
        this.now = now;
    }

    public List<CronWrapper<?>> getCronTabs(Trigger trigger) {
        return this.getCronTabs(trigger, null);
    }

    public List<CronWrapper<?>> getCronTabs(Trigger trigger, Hash hash) {
        ArrayList cronTabs = new ArrayList();
        int lineNumber = 0;
        String timezone = null;
        if (PluginUtil.hasParameterizedSchedulerPluginInstalled() && trigger instanceof ParameterizedTimerTrigger) {
            ParameterizedTimerTrigger ptt = (ParameterizedTimerTrigger)trigger;
            ptt.getCronTabList().getCronTabs().forEach(ct -> cronTabs.add(new CronWrapper.ParameterizedCronWrapper((ParameterizedCronTab)ct)));
            return cronTabs;
        }
        if (PluginUtil.hasExtendedTimerTriggerPluginInstalled() && trigger instanceof ExtendedTimerTrigger) {
            ExtendedTimerTrigger ett = (ExtendedTimerTrigger)trigger;
            ett.getExtendedCronTabList().getCronTabWrapperList().forEach(ct -> cronTabs.add(new CronWrapper.ExtendedCronTab((CronTabWrapper)ct)));
            return cronTabs;
        }
        String specification = trigger.getSpec();
        for (String line : specification.split("\\r?\\n")) {
            line = line.trim();
            if (++lineNumber == 1 && line.startsWith("TZ=")) {
                timezone = CronTabList.getValidTimezone((String)line.replace("TZ=", ""));
                continue;
            }
            if (line.isEmpty() || line.charAt(0) == '#') continue;
            try {
                CronTab cronTab = new CronTab(line, lineNumber, hash, timezone);
                cronTabs.add(new CronWrapper.ClassicCronTab(cronTab));
            }
            catch (IllegalArgumentException e) {
                String msg = "Unable to parse cron trigger spec: '" + line + "'";
                Logger.getLogger(this.getClass()).error((Object)msg, (Throwable)e);
            }
        }
        return cronTabs;
    }

    public List<Trigger> getCronTriggers(Job job, CalendarView.CalendarViewEventsType eventsType) {
        if (!(job instanceof TriggeredItem)) {
            return Collections.emptyList();
        }
        TriggeredItem ti = (TriggeredItem)job;
        Collection jobTriggers = ti.getTriggers().values();
        ArrayList<Trigger> cronTriggers = new ArrayList<Trigger>();
        for (Trigger jobTrigger : jobTriggers) {
            if (eventsType != CalendarView.CalendarViewEventsType.ALL && !(eventsType == CalendarView.CalendarViewEventsType.BUILDS ^ jobTrigger instanceof SCMTrigger)) continue;
            if (StringUtils.isNotBlank((String)jobTrigger.getSpec())) {
                cronTriggers.add(jobTrigger);
                continue;
            }
            if (PluginUtil.hasParameterizedSchedulerPluginInstalled() && jobTrigger instanceof ParameterizedTimerTrigger && StringUtils.isNotBlank((String)((ParameterizedTimerTrigger)jobTrigger).getParameterizedSpecification())) {
                cronTriggers.add(jobTrigger);
                continue;
            }
            if (!PluginUtil.hasExtendedTimerTriggerPluginInstalled() || !(jobTrigger instanceof ExtendedTimerTrigger) || !StringUtils.isNotBlank((String)((ExtendedTimerTrigger)jobTrigger).getCronSpec())) continue;
            cronTriggers.add(jobTrigger);
        }
        return cronTriggers;
    }

    public List<CronWrapper<?>> getCronTabs(Job job, CalendarView.CalendarViewEventsType eventsType) {
        ArrayList cronTabs = new ArrayList();
        for (Trigger trigger : this.getCronTriggers(job, eventsType)) {
            cronTabs.addAll(this.getCronTabs(trigger, Hash.from((String)job.getFullName())));
        }
        return cronTabs;
    }

    public Calendar getNextStart(Job job, CalendarView.CalendarViewEventsType eventsType) {
        Calendar next = null;
        List<CronWrapper<?>> cronTabs = this.getCronTabs(job, eventsType);
        for (CronWrapper<?> cronTab : cronTabs) {
            Calendar ceil = cronTab.ceil(this.now.nextMinute().getTimeInMillis());
            if (next != null && !ceil.before(next)) continue;
            next = ceil;
            next.set(13, 0);
            next.set(14, 0);
        }
        return next;
    }
}

