/*
 * Decompiled with CFR 0.152.
 */
package com.mwdle.bitwarden;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public final class PluginDirectoryProvider {
    private static final String PLUGIN_DIR_NAME = "bitwarden-credentials-provider-data";
    private static final Logger LOGGER = Logger.getLogger(PluginDirectoryProvider.class.getName());
    private static volatile File pluginDirectory;
    private static final Object lock;

    private PluginDirectoryProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getPluginDataDirectory() {
        File result = pluginDirectory;
        if (result != null) {
            return result;
        }
        Object object = lock;
        synchronized (object) {
            if (pluginDirectory != null) {
                return pluginDirectory;
            }
            File dir = new File(Jenkins.get().getRootDir(), PLUGIN_DIR_NAME);
            try {
                Files.createDirectories(dir.toPath(), new FileAttribute[0]);
                LOGGER.fine("Plugin data directory is ready: " + dir.getAbsolutePath());
            }
            catch (IOException e) {
                String errorMessage = "Could not create plugin directory: " + dir.getAbsolutePath() + "\nDoes Jenkins have proper file permissions?";
                LOGGER.log(Level.SEVERE, errorMessage, e);
                throw new RuntimeException(errorMessage, e);
            }
            pluginDirectory = dir;
            return dir;
        }
    }

    static {
        lock = new Object();
    }
}

