/*
 * Decompiled with CFR 0.152.
 */
package com.mwdle.bitwarden;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.mwdle.bitwarden.BitwardenCacheManager;
import com.mwdle.bitwarden.Messages;
import com.mwdle.bitwarden.cli.BitwardenCLI;
import com.mwdle.bitwarden.cli.BitwardenCLIManager;
import com.mwdle.bitwarden.cli.BitwardenSessionManager;
import com.mwdle.bitwarden.converters.CredentialProxy;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import jenkins.util.Timer;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.POST;

@Extension
@Symbol(value={"bitwarden"})
public class BitwardenConfig
extends GlobalConfiguration {
    private static final Logger LOGGER = Logger.getLogger(BitwardenConfig.class.getName());
    private transient BitwardenConfig loadedConfig;
    private String serverUrl;
    private String apiCredentialId;
    private String masterPasswordCredentialId;
    private String cliExecutablePath;
    private int cacheDuration = 5;
    private String fileCredentialSuffixes;

    public BitwardenConfig() {
        this.load();
        LOGGER.fine("BitwardenConfig loaded from disk.");
    }

    @Nonnull
    public String getDisplayName() {
        return Messages.BitwardenConfig_DisplayName();
    }

    public static BitwardenConfig getInstance() {
        return (BitwardenConfig)((Object)GlobalConfiguration.all().get(BitwardenConfig.class));
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getApiCredentialId() {
        return this.apiCredentialId;
    }

    public String getMasterPasswordCredentialId() {
        return this.masterPasswordCredentialId;
    }

    public String getCliExecutablePath() {
        return this.cliExecutablePath;
    }

    public int getCacheDuration() {
        return this.cacheDuration;
    }

    public String getFileCredentialSuffixes() {
        return this.fileCredentialSuffixes;
    }

    @DataBoundSetter
    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    @DataBoundSetter
    public void setApiCredentialId(String apiCredentialId) {
        this.apiCredentialId = apiCredentialId;
    }

    @DataBoundSetter
    public void setMasterPasswordCredentialId(String masterPasswordCredentialId) {
        this.masterPasswordCredentialId = masterPasswordCredentialId;
    }

    @DataBoundSetter
    public void setCliExecutablePath(String cliExecutablePath) {
        this.cliExecutablePath = cliExecutablePath;
    }

    @DataBoundSetter
    public void setCacheDuration(int cacheDuration) {
        this.cacheDuration = cacheDuration > 0 ? cacheDuration : 5;
    }

    @DataBoundSetter
    public void setFileCredentialSuffixes(String fileCredentialSuffixes) {
        this.fileCredentialSuffixes = fileCredentialSuffixes;
    }

    private BitwardenConfig snapshot() {
        BitwardenConfig snapshot = new BitwardenConfig();
        snapshot.serverUrl = this.serverUrl;
        snapshot.apiCredentialId = this.apiCredentialId;
        snapshot.masterPasswordCredentialId = this.masterPasswordCredentialId;
        snapshot.cliExecutablePath = this.cliExecutablePath;
        return snapshot;
    }

    public boolean isConfigured() {
        return this.apiCredentialId != null && !this.apiCredentialId.isEmpty() && this.masterPasswordCredentialId != null && !this.masterPasswordCredentialId.isEmpty();
    }

    public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
        super.configure(req, json);
        this.save();
        return true;
    }

    public void save() {
        boolean configChanged;
        super.save();
        boolean bl = configChanged = this.loadedConfig == null || !Objects.equals(this.serverUrl, this.loadedConfig.serverUrl) || !Objects.equals(this.apiCredentialId, this.loadedConfig.apiCredentialId) || !Objects.equals(this.masterPasswordCredentialId, this.loadedConfig.masterPasswordCredentialId) || !Objects.equals(this.cliExecutablePath, this.loadedConfig.cliExecutablePath);
        if (this.isConfigured() && configChanged) {
            LOGGER.info("Bitwarden configuration has changed, triggering background re-authentication and sync.");
            Timer.get().submit(() -> {
                BitwardenSessionManager.getInstance().invalidateSessionToken();
                BitwardenCacheManager.getInstance().invalidateCache();
                if (BitwardenCLIManager.getInstance().provisionExecutable()) {
                    BitwardenCacheManager.getInstance().updateCache();
                }
            });
        }
        this.loadedConfig = this.snapshot();
    }

    private CredentialsMatcher getCredentialsMatcher() {
        return CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withScope((CredentialsScope)CredentialsScope.SYSTEM), CredentialsMatchers.withScope((CredentialsScope)CredentialsScope.GLOBAL)}), (CredentialsMatcher & Serializable)credential -> !Proxy.isProxyClass(credential.getClass()) || !(Proxy.getInvocationHandler(credential) instanceof CredentialProxy)});
    }

    @POST
    public ListBoxModel doFillApiCredentialIdItems(@AncestorInPath Jenkins context, @QueryParameter String apiCredentialId) {
        if (!context.hasPermission(Jenkins.MANAGE)) {
            return new StandardListBoxModel().includeCurrentValue(apiCredentialId);
        }
        return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM2, (ItemGroup)context.getItemGroup(), StandardUsernamePasswordCredentials.class, Collections.emptyList(), this.getCredentialsMatcher()).includeCurrentValue(apiCredentialId);
    }

    @POST
    public ListBoxModel doFillMasterPasswordCredentialIdItems(@AncestorInPath Jenkins context, @QueryParameter String masterPasswordCredentialId) {
        if (!context.hasPermission(Jenkins.MANAGE)) {
            return new StandardListBoxModel().includeCurrentValue(masterPasswordCredentialId);
        }
        return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM2, (ItemGroup)context.getItemGroup(), StringCredentials.class, Collections.emptyList(), this.getCredentialsMatcher()).includeCurrentValue(masterPasswordCredentialId);
    }

    @POST
    public FormValidation doRefreshCache() {
        Jenkins.get().checkPermission(Jenkins.MANAGE);
        try {
            LOGGER.info("Manual cache refresh triggered by administrator.");
            BitwardenSessionManager.getInstance().invalidateSessionToken();
            BitwardenCacheManager.getInstance().updateCache();
            return FormValidation.ok((String)Messages.validation_refreshStarted());
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to start manual cache refresh", e);
            return FormValidation.error((String)Messages.validation_refreshError(e.getMessage()));
        }
    }

    @POST
    public FormValidation doCheckCliVersion() {
        Jenkins.get().checkPermission(Jenkins.MANAGE);
        try {
            String currentVersion = BitwardenCLI.version();
            return FormValidation.ok((String)Messages.validation_cliVersion(currentVersion));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to check Bitwarden CLI version", e);
            return FormValidation.error((String)Messages.validation_cliError(e.getMessage()));
        }
    }

    @POST
    public FormValidation doForceUpdateCli() {
        Jenkins.get().checkPermission(Jenkins.MANAGE);
        String userPath = this.getCliExecutablePath();
        if (userPath != null && !userPath.trim().isEmpty()) {
            return FormValidation.warning((String)Messages.validation_cliUpdateManual());
        }
        try {
            LOGGER.info("Manual Bitwarden CLI update triggered by administrator.");
            BitwardenCLIManager.getInstance().downloadLatestExecutable();
            String newVersion = BitwardenCLI.version();
            return FormValidation.ok((String)Messages.validation_cliUpdateOk(newVersion));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Manual CLI update failed", e);
            return FormValidation.error((String)Messages.validation_cliUpdateError(e.getMessage()));
        }
    }

    @POST
    public FormValidation doVerifySession() {
        Jenkins.get().checkPermission(Jenkins.MANAGE);
        if (!this.isConfigured()) {
            return FormValidation.warning((String)Messages.validation_sessionNotConfigured());
        }
        boolean isValid = BitwardenSessionManager.getInstance().isSessionValid();
        if (isValid) {
            return FormValidation.ok((String)Messages.validation_sessionOk());
        }
        return FormValidation.warning((String)Messages.validation_sessionNotFound());
    }
}

