// CHECKSTYLE:OFF

package com.mwdle.bitwarden;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code exception.loginError}: {@code Bitwarden login failed. Check
     * API key credential.}.
     * 
     * @return
     *     {@code Bitwarden login failed. Check API key credential.}
     */
    public static String exception_loginError() {
        return holder.format("exception.loginError");
    }

    /**
     * Key {@code exception.loginError}: {@code Bitwarden login failed. Check
     * API key credential.}.
     * 
     * @return
     *     {@code Bitwarden login failed. Check API key credential.}
     */
    public static Localizable _exception_loginError() {
        return new Localizable(holder, "exception.loginError");
    }

    /**
     * Key {@code description.idLabel}: {@code BW ID:}.
     * 
     * @return
     *     {@code BW ID:}
     */
    public static String description_idLabel() {
        return holder.format("description.idLabel");
    }

    /**
     * Key {@code description.idLabel}: {@code BW ID:}.
     * 
     * @return
     *     {@code BW ID:}
     */
    public static Localizable _description_idLabel() {
        return new Localizable(holder, "description.idLabel");
    }

    /**
     * Key {@code validation.sessionNotConfigured}: {@code Plugin is not
     * configured.}.
     * 
     * @return
     *     {@code Plugin is not configured.}
     */
    public static String validation_sessionNotConfigured() {
        return holder.format("validation.sessionNotConfigured");
    }

    /**
     * Key {@code validation.sessionNotConfigured}: {@code Plugin is not
     * configured.}.
     * 
     * @return
     *     {@code Plugin is not configured.}
     */
    public static Localizable _validation_sessionNotConfigured() {
        return new Localizable(holder, "validation.sessionNotConfigured");
    }

    /**
     * Key {@code description.nonUniqueLabel}: {@code non-unique name}.
     * 
     * @return
     *     {@code non-unique name}
     */
    public static String description_nonUniqueLabel() {
        return holder.format("description.nonUniqueLabel");
    }

    /**
     * Key {@code description.nonUniqueLabel}: {@code non-unique name}.
     * 
     * @return
     *     {@code non-unique name}
     */
    public static Localizable _description_nonUniqueLabel() {
        return new Localizable(holder, "description.nonUniqueLabel");
    }

    /**
     * Key {@code validation.cliUpdateError}: {@code Failed to update
     * Bitwarden CLI: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to update Bitwarden CLI: {0}}
     */
    public static String validation_cliUpdateError(Object arg0) {
        return holder.format("validation.cliUpdateError", arg0);
    }

    /**
     * Key {@code validation.cliUpdateError}: {@code Failed to update
     * Bitwarden CLI: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to update Bitwarden CLI: {0}}
     */
    public static Localizable _validation_cliUpdateError(Object arg0) {
        return new Localizable(holder, "validation.cliUpdateError", arg0);
    }

    /**
     * Key {@code exception.connectionError}: {@code Could not connect to the
     * Bitwarden server to log in.}.
     * 
     * @return
     *     {@code Could not connect to the Bitwarden server to log in.}
     */
    public static String exception_connectionError() {
        return holder.format("exception.connectionError");
    }

    /**
     * Key {@code exception.connectionError}: {@code Could not connect to the
     * Bitwarden server to log in.}.
     * 
     * @return
     *     {@code Could not connect to the Bitwarden server to log in.}
     */
    public static Localizable _exception_connectionError() {
        return new Localizable(holder, "exception.connectionError");
    }

    /**
     * Key {@code exception.unlockError}: {@code Bitwarden login failed.
     * Check master password credential.}.
     * 
     * @return
     *     {@code Bitwarden login failed. Check master password credential.}
     */
    public static String exception_unlockError() {
        return holder.format("exception.unlockError");
    }

    /**
     * Key {@code exception.unlockError}: {@code Bitwarden login failed.
     * Check master password credential.}.
     * 
     * @return
     *     {@code Bitwarden login failed. Check master password credential.}
     */
    public static Localizable _exception_unlockError() {
        return new Localizable(holder, "exception.unlockError");
    }

    /**
     * Key {@code validation.cliError}: {@code Failed to execute: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to execute: {0}}
     */
    public static String validation_cliError(Object arg0) {
        return holder.format("validation.cliError", arg0);
    }

    /**
     * Key {@code validation.cliError}: {@code Failed to execute: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to execute: {0}}
     */
    public static Localizable _validation_cliError(Object arg0) {
        return new Localizable(holder, "validation.cliError", arg0);
    }

    /**
     * Key {@code BitwardenCredentialsStore.DisplayName}: {@code Bitwarden}.
     * 
     * @return
     *     {@code Bitwarden}
     */
    public static String BitwardenCredentialsStore_DisplayName() {
        return holder.format("BitwardenCredentialsStore.DisplayName");
    }

    /**
     * Key {@code BitwardenCredentialsStore.DisplayName}: {@code Bitwarden}.
     * 
     * @return
     *     {@code Bitwarden}
     */
    public static Localizable _BitwardenCredentialsStore_DisplayName() {
        return new Localizable(holder, "BitwardenCredentialsStore.DisplayName");
    }

    /**
     * Key {@code validation.cliUpdateManual}: {@code A manual CLI path is
     * configured; automatic download is disabled.}.
     * 
     * @return
     *     {@code A manual CLI path is configured; automatic download is
     *     disabled.}
     */
    public static String validation_cliUpdateManual() {
        return holder.format("validation.cliUpdateManual");
    }

    /**
     * Key {@code validation.cliUpdateManual}: {@code A manual CLI path is
     * configured; automatic download is disabled.}.
     * 
     * @return
     *     {@code A manual CLI path is configured; automatic download is
     *     disabled.}
     */
    public static Localizable _validation_cliUpdateManual() {
        return new Localizable(holder, "validation.cliUpdateManual");
    }

    /**
     * Key {@code validation.sessionOk}: {@code Success! A valid session is
     * active and the plugin is ready to serve credentials.}.
     * 
     * @return
     *     {@code Success! A valid session is active and the plugin is ready to
     *     serve credentials.}
     */
    public static String validation_sessionOk() {
        return holder.format("validation.sessionOk");
    }

    /**
     * Key {@code validation.sessionOk}: {@code Success! A valid session is
     * active and the plugin is ready to serve credentials.}.
     * 
     * @return
     *     {@code Success! A valid session is active and the plugin is ready to
     *     serve credentials.}
     */
    public static Localizable _validation_sessionOk() {
        return new Localizable(holder, "validation.sessionOk");
    }

    /**
     * Key {@code exception.syncError}: {@code Could not connect to the
     * Bitwarden server to sync the vault.}.
     * 
     * @return
     *     {@code Could not connect to the Bitwarden server to sync the vault.}
     */
    public static String exception_syncError() {
        return holder.format("exception.syncError");
    }

    /**
     * Key {@code exception.syncError}: {@code Could not connect to the
     * Bitwarden server to sync the vault.}.
     * 
     * @return
     *     {@code Could not connect to the Bitwarden server to sync the vault.}
     */
    public static Localizable _exception_syncError() {
        return new Localizable(holder, "exception.syncError");
    }

    /**
     * Key {@code validation.refreshStarted}: {@code A background refresh has
     * started.}.
     * 
     * @return
     *     {@code A background refresh has started.}
     */
    public static String validation_refreshStarted() {
        return holder.format("validation.refreshStarted");
    }

    /**
     * Key {@code validation.refreshStarted}: {@code A background refresh has
     * started.}.
     * 
     * @return
     *     {@code A background refresh has started.}
     */
    public static Localizable _validation_refreshStarted() {
        return new Localizable(holder, "validation.refreshStarted");
    }

    /**
     * Key {@code validation.cliUpdateOk}: {@code Successfully downloaded
     * Bitwarden CLI. New version: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Successfully downloaded Bitwarden CLI. New version: {0}}
     */
    public static String validation_cliUpdateOk(Object arg0) {
        return holder.format("validation.cliUpdateOk", arg0);
    }

    /**
     * Key {@code validation.cliUpdateOk}: {@code Successfully downloaded
     * Bitwarden CLI. New version: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Successfully downloaded Bitwarden CLI. New version: {0}}
     */
    public static Localizable _validation_cliUpdateOk(Object arg0) {
        return new Localizable(holder, "validation.cliUpdateOk", arg0);
    }

    /**
     * Key {@code validation.cliVersion}: {@code Currently installed version:
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Currently installed version: {0}}
     */
    public static String validation_cliVersion(Object arg0) {
        return holder.format("validation.cliVersion", arg0);
    }

    /**
     * Key {@code validation.cliVersion}: {@code Currently installed version:
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Currently installed version: {0}}
     */
    public static Localizable _validation_cliVersion(Object arg0) {
        return new Localizable(holder, "validation.cliVersion", arg0);
    }

    /**
     * Key {@code BitwardenConfig.DisplayName}: {@code Bitwarden Credentials
     * Provider}.
     * 
     * @return
     *     {@code Bitwarden Credentials Provider}
     */
    public static String BitwardenConfig_DisplayName() {
        return holder.format("BitwardenConfig.DisplayName");
    }

    /**
     * Key {@code BitwardenConfig.DisplayName}: {@code Bitwarden Credentials
     * Provider}.
     * 
     * @return
     *     {@code Bitwarden Credentials Provider}
     */
    public static Localizable _BitwardenConfig_DisplayName() {
        return new Localizable(holder, "BitwardenConfig.DisplayName");
    }

    /**
     * Key {@code validation.sessionNotFound}: {@code No active session
     * found. This is normal after a restart or configuration change. Please
     * try again in a moment.}.
     * 
     * @return
     *     {@code No active session found. This is normal after a restart or
     *     configuration change. Please try again in a moment.}
     */
    public static String validation_sessionNotFound() {
        return holder.format("validation.sessionNotFound");
    }

    /**
     * Key {@code validation.sessionNotFound}: {@code No active session
     * found. This is normal after a restart or configuration change. Please
     * try again in a moment.}.
     * 
     * @return
     *     {@code No active session found. This is normal after a restart or
     *     configuration change. Please try again in a moment.}
     */
    public static Localizable _validation_sessionNotFound() {
        return new Localizable(holder, "validation.sessionNotFound");
    }

    /**
     * Key {@code validation.refreshError}: {@code Failed to start cache
     * refresh: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to start cache refresh: {0}}
     */
    public static String validation_refreshError(Object arg0) {
        return holder.format("validation.refreshError", arg0);
    }

    /**
     * Key {@code validation.refreshError}: {@code Failed to start cache
     * refresh: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to start cache refresh: {0}}
     */
    public static Localizable _validation_refreshError(Object arg0) {
        return new Localizable(holder, "validation.refreshError", arg0);
    }

}
