/*
 * Decompiled with CFR 0.152.
 */
package com.mwdle.bitwarden.cli;

import com.mwdle.bitwarden.BitwardenConfig;
import com.mwdle.bitwarden.PluginDirectoryProvider;
import hudson.ProxyConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class BitwardenCLIManager {
    private static final BitwardenCLIManager INSTANCE = new BitwardenCLIManager();
    private static final Logger LOGGER = Logger.getLogger(BitwardenCLIManager.class.getName());
    private volatile String executablePath;
    private final transient Object provisionLock = new Object();

    private BitwardenCLIManager() {
    }

    public static BitwardenCLIManager getInstance() {
        return INSTANCE;
    }

    private void checkSupportedArchitecture() {
        String arch = System.getProperty("os.arch").toLowerCase();
        if (!"amd64".equals(arch) && !"x86_64".equals(arch)) {
            throw new UnsupportedOperationException("Automatic download of Bitwarden CLI is not supported on this CPU architecture: " + arch + ". Please install the CLI manually and provide the path in the plugin configuration.");
        }
    }

    private String getDownloadUrl() {
        this.checkSupportedArchitecture();
        OS os = OS.detect();
        return switch (os) {
            default -> throw new IncompatibleClassChangeError();
            case OS.WINDOWS -> "https://bitwarden.com/download/?app=cli&platform=windows";
            case OS.MAC -> "https://bitwarden.com/download/?app=cli&platform=macos";
            case OS.LINUX -> "https://bitwarden.com/download/?app=cli&platform=linux";
        };
    }

    private String getExecutableName() {
        OS os = OS.detect();
        return os == OS.WINDOWS ? "bw.exe" : "bw";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadAndExtract(URI downloadUrl, File targetFile) throws IOException, InterruptedException {
        LOGGER.fine(() -> "Downloading Bitwarden CLI from URL: " + String.valueOf(downloadUrl));
        File bwCliZip = File.createTempFile("bw-cli", ".zip");
        try {
            HttpClient client = ProxyConfiguration.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder(downloadUrl).build();
            HttpResponse<InputStream> response = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
            if (response.statusCode() != 200) {
                throw new IOException("Failed to download file. Status code: " + response.statusCode());
            }
            try (InputStream in = response.body();){
                Files.copy(in, bwCliZip.toPath(), StandardCopyOption.REPLACE_EXISTING);
                LOGGER.fine("Downloaded zip to: " + bwCliZip.getAbsolutePath());
            }
            try (ZipFile zipFile = new ZipFile(bwCliZip);){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                boolean foundExecutable = false;
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!entry.getName().equalsIgnoreCase("bw") && !entry.getName().equalsIgnoreCase("bw.exe")) continue;
                    try (InputStream zipInputStream = zipFile.getInputStream(entry);){
                        Files.copy(zipInputStream, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        LOGGER.fine("Extracted executable: " + targetFile.getAbsolutePath());
                        foundExecutable = true;
                        break;
                    }
                }
                if (!foundExecutable) {
                    throw new IOException("Could not find 'bw' or 'bw.exe' executable in the downloaded zip file.");
                }
            }
        }
        finally {
            Files.deleteIfExists(bwCliZip.toPath());
        }
        if (targetFile.setExecutable(true, true)) {
            LOGGER.fine("Downloaded Bitwarden CLI executable: " + targetFile.getAbsolutePath());
        } else {
            LOGGER.warning("Could not set executable permission on Bitwarden CLI.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadLatestExecutable() {
        Object object = this.provisionLock;
        synchronized (object) {
            LOGGER.info("Downloading and provisioning the latest Bitwarden CLI executable...");
            try {
                String downloadUrl = this.getDownloadUrl();
                String executableName = this.getExecutableName();
                File pluginBinDir = this.getPluginBinDirectory();
                File executableFile = new File(pluginBinDir, executableName);
                this.downloadAndExtract(new URI(downloadUrl), executableFile);
                this.executablePath = executableFile.getAbsolutePath();
                LOGGER.info("Successfully provisioned Bitwarden CLI at: " + this.executablePath);
                return true;
            }
            catch (IOException | InterruptedException | UnsupportedOperationException | URISyntaxException e) {
                LOGGER.log(Level.SEVERE, "Failed to provision the Bitwarden executable.", e);
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                return false;
            }
        }
    }

    public boolean provisionExecutable() {
        String executableName = this.getExecutableName();
        File pluginBinDir = this.getPluginBinDirectory();
        File executableFile = new File(pluginBinDir, executableName);
        if (executableFile.exists()) {
            this.executablePath = executableFile.getAbsolutePath();
            return true;
        }
        return this.downloadLatestExecutable();
    }

    public String getExecutablePath() {
        String userPath = BitwardenConfig.getInstance().getCliExecutablePath();
        if (userPath != null && !userPath.trim().isEmpty()) {
            File userCli = new File(userPath.trim());
            if (userCli.exists() && userCli.canExecute()) {
                LOGGER.fine(() -> "Using user-configured Bitwarden CLI path: " + userPath);
                return userCli.getAbsolutePath();
            }
            LOGGER.warning("User-configured Bitwarden CLI path is invalid (does not exist or is not executable). Falling back to automatic provisioning. Path: " + userPath);
        }
        if (this.executablePath != null && new File(this.executablePath).exists()) {
            return this.executablePath;
        }
        if (this.provisionExecutable()) {
            return this.executablePath;
        }
        throw new IllegalStateException("Bitwarden CLI is not installed and could not be downloaded automatically. If on an unsupported architecture, please install it manually and set the path in the Jenkins configuration.");
    }

    private File getPluginBinDirectory() {
        File pluginDir = PluginDirectoryProvider.getPluginDataDirectory();
        File binDir = new File(pluginDir, "bin");
        try {
            Files.createDirectories(binDir.toPath(), new FileAttribute[0]);
            LOGGER.fine("Plugin bin directory is ready: " + binDir.getAbsolutePath());
        }
        catch (IOException e) {
            String errorMessage = "Could not create plugin bin directory: " + binDir.getAbsolutePath() + "\nDoes Jenkins have proper file permissions?";
            throw new RuntimeException(errorMessage, e);
        }
        return binDir;
    }

    private static enum OS {
        WINDOWS,
        MAC,
        LINUX;


        static OS detect() {
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.contains("win")) {
                return WINDOWS;
            }
            if (osName.contains("mac")) {
                return MAC;
            }
            if (osName.contains("nix") || osName.contains("nux") || osName.contains("aix")) {
                return LINUX;
            }
            throw new UnsupportedOperationException("Unsupported OS: " + osName);
        }
    }
}

