/*
 * Decompiled with CFR 0.152.
 */
package com.mwdle.bitwarden;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.mwdle.bitwarden.BitwardenConfig;
import com.mwdle.bitwarden.PluginDirectoryProvider;
import com.mwdle.bitwarden.cli.BitwardenCLI;
import com.mwdle.bitwarden.cli.BitwardenSessionManager;
import com.mwdle.bitwarden.model.BitwardenItemMetadata;
import com.thoughtworks.xstream.XStream;
import hudson.Extension;
import hudson.XmlFile;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.util.XStream2;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.util.Timer;

@Extension
public class BitwardenCacheManager {
    private static final Logger LOGGER = Logger.getLogger(BitwardenCacheManager.class.getName());
    private static final String CACHE_NAME = "bitwardenItemsMetadata";
    private final transient Object cacheLock = new Object();
    private volatile transient LoadingCache<String, List<BitwardenItemMetadata>> itemMetadataCache;

    public static BitwardenCacheManager getInstance() {
        return (BitwardenCacheManager)Jenkins.get().getExtensionList(BitwardenCacheManager.class).get(0);
    }

    private XmlFile getCacheFile() {
        File pluginDir = PluginDirectoryProvider.getPluginDataDirectory();
        return new XmlFile((XStream)new XStream2(), new File(pluginDir, "cache.xml"));
    }

    public void updateCache() {
        this.getCache().refresh((Object)CACHE_NAME);
    }

    public void invalidateCache() {
        this.getCache().invalidate((Object)CACHE_NAME);
    }

    @Initializer(after=InitMilestone.SYSTEM_CONFIG_ADAPTED)
    public void triggerStartupCacheUpdate() {
        BitwardenConfig config = BitwardenConfig.getInstance();
        if (!config.isConfigured()) {
            LOGGER.info("Bitwarden plugin is not configured. Skipping initial cache update.");
            return;
        }
        Timer.get().submit(this::updateCache);
    }

    public List<BitwardenItemMetadata> getMetadata() {
        LoadingCache<String, List<BitwardenItemMetadata>> cache = this.getCache();
        List<BitwardenItemMetadata> metadata = (List<BitwardenItemMetadata>)cache.getIfPresent((Object)CACHE_NAME);
        Timer.get().submit(() -> {
            try {
                cache.get((Object)CACHE_NAME);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Background cache refresh failed.", e);
            }
        });
        return metadata != null ? metadata : Collections.emptyList();
    }

    private List<BitwardenItemMetadata> fetchData() throws IOException, InterruptedException {
        LOGGER.info("Bitwarden metadata cache is loading/refreshing...");
        BitwardenCLI.sync(BitwardenSessionManager.getInstance().getSessionToken());
        List<BitwardenItemMetadata> metadata = BitwardenCLI.listItemsMetadata(BitwardenSessionManager.getInstance().getSessionToken());
        try {
            this.getCacheFile().write(metadata);
            LOGGER.info("Successfully saved credential metadata cache to disk.");
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to save credential metadata cache to disk.", e);
        }
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoadingCache<String, List<BitwardenItemMetadata>> getCache() {
        LoadingCache result = this.itemMetadataCache;
        if (result == null) {
            Object object = this.cacheLock;
            synchronized (object) {
                result = this.itemMetadataCache;
                if (result == null) {
                    int cacheDurationMinutes = BitwardenConfig.getInstance().getCacheDuration();
                    LOGGER.info("Initializing Bitwarden metadata cache with a " + cacheDurationMinutes + " minute expiry.");
                    ListeningScheduledExecutorService executor = MoreExecutors.listeningDecorator((ScheduledExecutorService)Timer.get());
                    result = CacheBuilder.newBuilder().refreshAfterWrite((long)cacheDurationMinutes, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List<BitwardenItemMetadata>>((ListeningExecutorService)executor){
                        final /* synthetic */ ListeningExecutorService val$executor;
                        {
                            this.val$executor = listeningExecutorService;
                        }

                        @Nonnull
                        public List<BitwardenItemMetadata> load(@Nonnull String key) throws IOException, InterruptedException {
                            return BitwardenCacheManager.this.fetchData();
                        }

                        @Nonnull
                        public ListenableFuture<List<BitwardenItemMetadata>> reload(@Nonnull String key, @Nonnull List<BitwardenItemMetadata> oldValue) {
                            return this.val$executor.submit(() -> BitwardenCacheManager.this.fetchData());
                        }
                    });
                    try {
                        XmlFile cacheFile = this.getCacheFile();
                        if (cacheFile.exists()) {
                            List persistedMetadata = (List)cacheFile.read();
                            result.put((Object)CACHE_NAME, (Object)persistedMetadata);
                            LOGGER.info("Successfully loaded " + persistedMetadata.size() + " credential metadata items from disk.");
                        }
                    }
                    catch (IOException | ClassCastException e) {
                        LOGGER.log(Level.WARNING, "Could not load credential metadata cache from disk.", e);
                    }
                    this.itemMetadataCache = result;
                }
            }
        }
        return result;
    }
}

