/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.credentials.secretsmanager.config;

import hudson.Extension;
import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import io.jenkins.plugins.credentials.secretsmanager.Messages;
import io.jenkins.plugins.credentials.secretsmanager.config.ClientConfiguration;
import io.jenkins.plugins.credentials.secretsmanager.config.credentialsProvider.CredentialsProvider;
import io.jenkins.plugins.credentials.secretsmanager.config.credentialsProvider.DefaultAWSCredentialsProviderChain;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.apache.http.client.utils.URIBuilder;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.RegionMetadata;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;

public class Client
extends AbstractDescribableImpl<Client>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ClientConfiguration clientConfiguration;
    private CredentialsProvider credentialsProvider;
    private String endpointUrl;
    private String region;

    @DataBoundConstructor
    public Client(ClientConfiguration clientConfiguration, CredentialsProvider credentialsProvider, String endpointUrl, String region) {
        this.clientConfiguration = clientConfiguration;
        this.credentialsProvider = credentialsProvider;
        this.endpointUrl = endpointUrl;
        this.region = region;
    }

    public ClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }

    @DataBoundSetter
    public void setClientConfiguration(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    @DataBoundSetter
    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public String getRegion() {
        return this.region;
    }

    @DataBoundSetter
    public void setRegion(String region) {
        this.region = Util.fixEmptyAndTrim((String)region);
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    @DataBoundSetter
    public void setEndpointUrl(String endpointUrl) {
        this.endpointUrl = Util.fixEmptyAndTrim((String)endpointUrl);
    }

    private static Optional<ProxyConfiguration> getProxyConfiguration() {
        Optional<Jenkins> maybeJenkins = Optional.ofNullable(Jenkins.getInstanceOrNull());
        return maybeJenkins.flatMap(j -> Optional.ofNullable(j.getProxy()));
    }

    static software.amazon.awssdk.http.apache.ProxyConfiguration toAwsProxyConfiguration(ProxyConfiguration conf) {
        URI proxyEndpoint;
        try {
            proxyEndpoint = new URIBuilder().setHost(conf.getName()).setPort(conf.getPort()).build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        return (software.amazon.awssdk.http.apache.ProxyConfiguration)software.amazon.awssdk.http.apache.ProxyConfiguration.builder().nonProxyHosts(Collections.singleton(conf.getNoProxyHost())).endpoint(proxyEndpoint).username(conf.getUserName()).password(Secret.toString((Secret)conf.getSecretPassword())).build();
    }

    public SecretsManagerClient build() {
        SecretsManagerClientBuilder builder = SecretsManagerClient.builder();
        if (this.clientConfiguration != null) {
            builder.httpClient(this.clientConfiguration.build());
        } else {
            Optional<ProxyConfiguration> proxyConfiguration = Client.getProxyConfiguration();
            proxyConfiguration.ifPresent(p -> {
                software.amazon.awssdk.http.apache.ProxyConfiguration proxyClientConfiguration = Client.toAwsProxyConfiguration(p);
                SdkHttpClient httpClient = ApacheHttpClient.builder().proxyConfiguration(proxyClientConfiguration).build();
                builder.httpClient(httpClient);
            });
        }
        if (this.credentialsProvider != null) {
            builder.credentialsProvider(this.credentialsProvider.build());
        }
        if (this.endpointUrl != null && !this.endpointUrl.isEmpty()) {
            URI theEndpointUrl = URI.create(this.endpointUrl);
            builder.endpointOverride(theEndpointUrl);
        }
        if (this.region != null && !this.region.isEmpty()) {
            Region theRegion = Region.of((String)this.region);
            builder.region(theRegion);
        }
        return (SecretsManagerClient)builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Client client = (Client)o;
        return Objects.equals(this.clientConfiguration, client.clientConfiguration) && Objects.equals(this.credentialsProvider, client.credentialsProvider) && Objects.equals(this.endpointUrl, client.endpointUrl) && Objects.equals(this.region, client.region);
    }

    public int hashCode() {
        return Objects.hash(this.clientConfiguration, this.credentialsProvider, this.endpointUrl, this.region);
    }

    @Extension
    @Symbol(value={"client"})
    public static class DescriptorImpl
    extends Descriptor<Client> {
        public CredentialsProvider getDefaultCredentialsProvider() {
            return new DefaultAWSCredentialsProviderChain();
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.client();
        }

        public ListBoxModel doFillRegionItems() {
            ListBoxModel regions = new ListBoxModel();
            regions.add("", "");
            for (Region region : Region.regions()) {
                RegionMetadata metadata = region.metadata();
                regions.add(metadata.description(), metadata.id());
            }
            return regions;
        }
    }
}

