/*
 * Decompiled with CFR 0.152.
 */
package com.xliic.ci.jenkins;

import com.xliic.cicd.common.Logger;
import java.io.PrintStream;

public class LoggerImpl
implements Logger {
    private PrintStream logger;
    private int level;

    LoggerImpl(PrintStream logger, String logLevel) {
        this.logger = logger;
        switch (logLevel.toUpperCase()) {
            case "FATAL": {
                this.level = 5;
                break;
            }
            case "ERROR": {
                this.level = 4;
                break;
            }
            case "WARN": {
                this.level = 3;
                break;
            }
            case "INFO": {
                this.level = 2;
                break;
            }
            case "DEBUG": {
                this.level = 1;
                break;
            }
            default: {
                logger.println("Unknown log level specified, setting log level to INFO");
                this.level = 2;
            }
        }
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void fatal(String message) {
        if (5 >= this.level) {
            this.logger.println(message);
        }
    }

    public void error(String message) {
        if (4 >= this.level) {
            this.logger.println(message);
        }
    }

    public void warn(String message) {
        if (3 >= this.level) {
            this.logger.println(message);
        }
    }

    public void info(String message) {
        if (2 >= this.level) {
            this.logger.println(message);
        }
    }

    public void debug(String message) {
        if (1 >= this.level) {
            this.logger.println(message);
        }
    }
}

