/*
 * Decompiled with CFR 0.152.
 */
package com.xliic.ci.jenkins;

import com.xliic.cicd.common.OpenApiFinder;
import com.xliic.cicd.common.TaskException;
import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import hudson.util.DirScanner;
import hudson.util.FileVisitor;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import jenkins.MasterToSlaveFileCallable;

class Finder
extends MasterToSlaveFileCallable<List<URI>>
implements OpenApiFinder {
    private static final long serialVersionUID = 1L;
    private FilePath workspace;
    private String includes = "";
    private String excludes = "";

    public Finder(FilePath workspace) {
        this.workspace = workspace;
    }

    public void setPatterns(String[] patterns) {
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList<String> excludes = new ArrayList<String>();
        for (String pattern : patterns) {
            if (pattern.startsWith("!")) {
                excludes.add(pattern.substring(1));
                continue;
            }
            includes.add(pattern);
        }
        this.includes = String.join((CharSequence)",", includes);
        this.excludes = String.join((CharSequence)",", excludes);
    }

    public List<URI> find() throws IOException, InterruptedException {
        List openApiFiles = (List)this.workspace.act((FilePath.FileCallable)this);
        return openApiFiles;
    }

    public List<URI> invoke(File workspace, VirtualChannel channel) throws IOException, InterruptedException {
        final ArrayList<URI> found = new ArrayList<URI>();
        DirScanner.Glob scanner = new DirScanner.Glob(this.includes, this.excludes);
        scanner.scan(workspace, new FileVisitor(){

            public void visit(File f, String relativePath) throws IOException {
                found.add(f.toURI());
            }
        });
        return found;
    }

    public OpenApiFinder child(String dir) throws TaskException, IOException {
        return new Finder(this.workspace.child(dir));
    }
}

