/*
 * Decompiled with CFR 0.152.
 */
package com.xliic.ci.jenkins;

import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.xliic.ci.jenkins.ApiKey;
import com.xliic.ci.jenkins.LoggerImpl;
import com.xliic.ci.jenkins.Messages;
import com.xliic.ci.jenkins.RemoteAuditTask;
import com.xliic.cicd.common.Logger;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class AuditBuilder
extends Builder
implements SimpleBuildStep {
    private int minScore = 75;
    private String credentialsId;
    private String platformUrl = "https://us.42crunch.cloud";
    private String logLevel;
    private String repositoryName = "${GIT_URL}";
    private String branchName = "";
    private String tagName = "";
    private String prId = "";
    private String prTargetBranch = "";
    private String defaultCollectionName = "";
    private String rootDirectory = "";
    private String jsonReport;
    private String apiTags;
    private boolean skipLocalChecks = false;
    private boolean ignoreNetworkErrors = false;
    private boolean ignoreFailures = false;
    private String shareEveryone;

    @DataBoundConstructor
    public AuditBuilder(String credentialsId, int minScore, String platformUrl) {
        this.credentialsId = credentialsId;
        this.minScore = minScore;
        this.platformUrl = platformUrl;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public int getMinScore() {
        return this.minScore;
    }

    @DataBoundSetter
    public void setMinScore(int minScore) {
        this.minScore = minScore;
    }

    public String getPlatformUrl() {
        return this.platformUrl;
    }

    @DataBoundSetter
    public void setPlatformUrl(String platformUrl) {
        this.platformUrl = platformUrl;
    }

    public String getLogLevel() {
        if (this.logLevel == null) {
            return "INFO";
        }
        return this.logLevel;
    }

    @DataBoundSetter
    public void setSkipLocalChecks(boolean skipLocalChecks) {
        this.skipLocalChecks = skipLocalChecks;
    }

    public boolean getSkipLocalChecks() {
        return this.skipLocalChecks;
    }

    @DataBoundSetter
    public void setIgnoreNetworkErrors(boolean ignoreNetworkErrors) {
        this.ignoreNetworkErrors = ignoreNetworkErrors;
    }

    public boolean getIgnoreNetworkErrors() {
        return this.ignoreNetworkErrors;
    }

    @DataBoundSetter
    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    public boolean getIgnoreFailures() {
        return this.ignoreFailures;
    }

    @DataBoundSetter
    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    @DataBoundSetter
    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public String getBranchName() {
        return this.branchName;
    }

    @DataBoundSetter
    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    public String getTagName() {
        return this.tagName;
    }

    @DataBoundSetter
    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public String getPrId() {
        return this.prId;
    }

    @DataBoundSetter
    public void setPrId(String prId) {
        this.prId = prId;
    }

    public String getPrTargetBranch() {
        return this.prTargetBranch;
    }

    @DataBoundSetter
    public void setPrTargetBranch(String prTargetBranch) {
        this.prTargetBranch = prTargetBranch;
    }

    public String getDefaultCollectionName() {
        return this.defaultCollectionName;
    }

    @DataBoundSetter
    public void setDefaultCollectionName(String defaultCollectionName) {
        this.defaultCollectionName = defaultCollectionName;
    }

    public String getRootDirectory() {
        return this.rootDirectory;
    }

    @DataBoundSetter
    public void setRootDirectory(String rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    public String getJsonReport() {
        return this.jsonReport;
    }

    @DataBoundSetter
    public void setJsonReport(String jsonReport) {
        this.jsonReport = jsonReport;
    }

    public String getApiTags() {
        return this.apiTags;
    }

    @DataBoundSetter
    public void setApiTags(String apiTags) {
        this.apiTags = apiTags;
    }

    public String getShareEveryone() {
        if (this.shareEveryone == null) {
            return "OFF";
        }
        return this.shareEveryone;
    }

    @DataBoundSetter
    public void setShareEveryone(String shareEveryone) {
        this.shareEveryone = shareEveryone;
    }

    private String expandVariable(String name, String value, Run<?, ?> build, TaskListener listener, Logger logger) throws IOException, InterruptedException {
        if (build instanceof AbstractBuild && value != null && !value.equals("")) {
            EnvVars env = build.getEnvironment(listener);
            env.overrideAll(((AbstractBuild)build).getBuildVariables());
            String expanded = env.expand(value);
            logger.debug(String.format("Expanded %s parameter '%s' to '%s'", name, value, expanded));
            return expanded;
        }
        return value;
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        String actualRepositoryName;
        LoggerImpl logger = new LoggerImpl(listener.getLogger(), this.logLevel);
        ApiKey credential = (ApiKey)CredentialsProvider.findCredentialById((String)this.credentialsId, ApiKey.class, run, Collections.emptyList());
        if (credential == null) {
            throw new AbortException("Unable to load API Token credential: " + this.credentialsId);
        }
        SecretImpl apiKey = new SecretImpl(credential.getApiKey());
        if (!apiKey.getPlainText().matches("(api_)?[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}")) {
            throw new AbortException("Invalid format of API Token");
        }
        String trimmedUrl = Util.fixEmptyAndTrim((String)this.platformUrl);
        if (trimmedUrl != null) {
            try {
                URI url = new URI(trimmedUrl);
                if (url.getScheme() == null || !url.getScheme().equals("https")) {
                    throw new AbortException(String.format("Bad platform URL '%s': only https:// URLs are allowed", url));
                }
                this.platformUrl = String.format("%s://%s", url.getScheme(), url.getRawAuthority());
            }
            catch (URISyntaxException e) {
                throw new AbortException(String.format("Malformed platform URL '%s': %s", trimmedUrl, e.getMessage()));
            }
        }
        if ((actualRepositoryName = this.expandVariable("repositoryName", this.repositoryName, run, listener, logger)) == null || actualRepositoryName.length() == 0) {
            throw new AbortException(String.format("Parameter repositoryName must be set", new Object[0]));
        }
        String actualBranchName = this.expandVariable("branchName", this.branchName, run, listener, logger);
        String actualTagName = this.expandVariable("tagName", this.tagName, run, listener, logger);
        String actualPrId = this.expandVariable("prId", this.prId, run, listener, logger);
        String actualPrTargetBranch = this.expandVariable("prTargetBranch", this.prTargetBranch, run, listener, logger);
        ProxyConfiguration proxyConfiguration = Jenkins.get().proxy;
        VirtualChannel channel = launcher.getChannel();
        if (channel == null) {
            throw new AbortException("Unable to get channel to launch AuditTask");
        }
        channel.call((Callable)new RemoteAuditTask(workspace, listener, apiKey, this.getPlatformUrl(), this.getLogLevel(), this.getDefaultCollectionName(), this.getRootDirectory(), this.getJsonReport(), this.getApiTags(), this.getSkipLocalChecks(), this.getIgnoreNetworkErrors(), this.getIgnoreFailures(), this.getShareEveryone(), this.minScore, proxyConfiguration, actualRepositoryName, actualBranchName, actualTagName, actualPrId, actualPrTargetBranch));
    }

    static class SecretImpl
    implements com.xliic.cicd.audit.Secret,
    Serializable {
        private Secret secret;

        public SecretImpl(Secret secret) {
            this.secret = secret;
        }

        public String getPlainText() {
            return this.secret.getPlainText();
        }
    }

    @Symbol(value={"audit"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public String getDisplayName() {
            return Messages.descriptor_displayName();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item ancestor, @QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (ancestor == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !ancestor.hasPermission(Item.EXTENDED_READ) && !ancestor.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(credentialsId);
            }
            return result.includeMatchingAs(ACL.SYSTEM, ancestor, ApiKey.class, Collections.emptyList(), CredentialsMatchers.always()).includeCurrentValue(credentialsId);
        }

        public FormValidation doCheckPlatformUrl(@QueryParameter String value) {
            String trimmedUrl = Util.fixEmptyAndTrim((String)value);
            if (trimmedUrl != null) {
                try {
                    new URI(trimmedUrl);
                }
                catch (URISyntaxException e) {
                    return FormValidation.error((String)"Malformed URL");
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckApiTags(@QueryParameter String value) {
            String pattern;
            Pattern regex;
            Matcher matcher;
            String trimmedInput = Util.fixEmptyAndTrim((String)value);
            if (trimmedInput != null && !(matcher = (regex = Pattern.compile(pattern = "^[\\w]+:[\\w]+( [\\w]+:[\\w]+)*$")).matcher(trimmedInput)).matches()) {
                return FormValidation.error((String)"Please use the pattern 'category:tag category2:tag2...'");
            }
            return FormValidation.ok();
        }
    }
}

