/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_bitbucket_pipeline;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMNavigator;
import hudson.model.TopLevelItem;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.BitbucketApi;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.BitbucketRepositoryContainer;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbOrg;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmOrganization;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmRepositoryContainer;
import jenkins.branch.OrganizationFolder;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMNavigator;
import org.kohsuke.stapler.export.Exported;

public class BitbucketOrg
extends ScmOrganization {
    private final Link self;
    private final BbOrg project;
    private final BitbucketApi api;

    public BitbucketOrg(BbOrg project, BitbucketApi api, Link parent) {
        this.self = parent.rel(project.getKey());
        this.project = project;
        this.api = api;
    }

    public Link getLink() {
        return this.self;
    }

    public String getName() {
        return this.project.getName();
    }

    @Exported(name="key")
    public String getKey() {
        return this.project.getKey();
    }

    public String getAvatar() {
        return this.project.getAvatar();
    }

    public boolean isJenkinsOrganizationPipeline() {
        for (TopLevelItem item : Jenkins.get().getItems()) {
            if (!(item instanceof OrganizationFolder)) continue;
            OrganizationFolder folder = (OrganizationFolder)item;
            for (SCMNavigator navigator : folder.getNavigators()) {
                BitbucketSCMNavigator scmNavigator;
                if (!(navigator instanceof BitbucketSCMNavigator) || !(scmNavigator = (BitbucketSCMNavigator)navigator).getRepoOwner().equals(this.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public ScmRepositoryContainer getRepositories() {
        return new BitbucketRepositoryContainer(this.project, this.api, (Reachable)this);
    }
}

