/*
 * Decompiled with CFR 0.152.
 */
package com.igalg.jenkins.plugins.multibranch.buildstrategy;

import com.igalg.jenkins.plugins.multibranch.buildstrategy.BranchBuildStrategyHelper;
import com.igalg.jenkins.plugins.multibranch.buildstrategy.IncludeRegionBranchBuildStrategy;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.util.Set;
import jenkins.branch.BranchBuildStrategyDescriptor;
import jenkins.scm.api.SCMFileSystem;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class IncludeRegionByFileBranchBuildStrategy
extends IncludeRegionBranchBuildStrategy {
    private final String includeFilePath;

    @DataBoundConstructor
    public IncludeRegionByFileBranchBuildStrategy(String includeFilePath) {
        this.includeFilePath = StringUtils.isBlank((String)includeFilePath) ? ".jenkinsIncludeFile" : includeFilePath;
    }

    public String getIncludeFilePath() {
        return this.includeFilePath;
    }

    @Override
    Set<String> getPatterns(SCMFileSystem fileSystem) {
        return BranchBuildStrategyHelper.getPatternsFromFile(fileSystem, this.includeFilePath);
    }

    @Extension
    public static class DescriptorImpl
    extends BranchBuildStrategyDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Accept build by included regions strategy defined in file";
        }
    }
}

