/*
 * Decompiled with CFR 0.152.
 */
package com.igalg.jenkins.plugins.multibranch.buildstrategy;

import com.igalg.jenkins.plugins.multibranch.buildstrategy.AbstractBranchBuildStrategy;
import com.igalg.jenkins.plugins.multibranch.buildstrategy.AbstractRegionBranchBuildStrategy;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.tools.ant.types.selectors.SelectorUtils;

abstract class IncludeRegionBranchBuildStrategy
extends AbstractRegionBranchBuildStrategy {
    private static final Logger LOGGER = Logger.getLogger(IncludeRegionBranchBuildStrategy.class.getName());

    protected IncludeRegionBranchBuildStrategy() {
        super(AbstractBranchBuildStrategy.Strategy.INCLUDED);
    }

    @Override
    boolean shouldRunBuild(Set<String> patterns, Set<String> paths) {
        for (String path : paths) {
            for (String pattern : patterns) {
                if (SelectorUtils.matchPath((String)pattern, (String)path)) {
                    LOGGER.fine(() -> "Matched included region: " + pattern + " with file path: " + path);
                    return true;
                }
                LOGGER.fine(() -> "Not matched included region: " + pattern + " with file path: " + path);
            }
        }
        LOGGER.info(() -> "No matching any included regions, skipping build");
        return false;
    }
}

