/*
 * Decompiled with CFR 0.152.
 */
package com.igalg.jenkins.plugins.multibranch.buildstrategy;

import com.igalg.jenkins.plugins.multibranch.buildstrategy.AbstractMessageBranchBuildStrategy;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.branch.BranchBuildStrategyDescriptor;
import jenkins.scm.api.SCMFileSystem;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class ExcludeMessageBranchBuildStrategy
extends AbstractMessageBranchBuildStrategy {
    private final String excludedMessages;

    @DataBoundConstructor
    public ExcludeMessageBranchBuildStrategy(String excludedMessages) {
        this.excludedMessages = excludedMessages;
    }

    public String getExcludedMessages() {
        return this.excludedMessages;
    }

    @Override
    Set<String> getPatterns(SCMFileSystem ignored) {
        return Arrays.stream(this.excludedMessages.split("\n")).filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.toSet());
    }

    @Extension
    public static class DescriptorImpl
    extends BranchBuildStrategyDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Cancel build by excluded commit messages strategy";
        }
    }
}

