/*
 * Decompiled with CFR 0.152.
 */
package com.igalg.jenkins.plugins.multibranch.buildstrategy;

import com.igalg.jenkins.plugins.multibranch.buildstrategy.AbstractBranchBuildStrategy;
import hudson.plugins.git.GitChangeSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class AbstractMessageBranchBuildStrategy
extends AbstractBranchBuildStrategy {
    private static final Logger LOGGER = Logger.getLogger(AbstractMessageBranchBuildStrategy.class.getName());

    protected AbstractMessageBranchBuildStrategy() {
        super(AbstractBranchBuildStrategy.Strategy.EXCLUDED);
    }

    @Override
    Set<String> getExpressions(List<GitChangeSet> changeSets) {
        GitChangeSet lastCommit = changeSets.get(0);
        String commitMessage = lastCommit.getMsg();
        LOGGER.fine(() -> "Message: \"" + commitMessage + "\" from commit: " + lastCommit.getCommitId());
        return Collections.singleton(commitMessage);
    }

    @Override
    boolean shouldRunBuild(Set<String> patterns, Set<String> singletonMessages) {
        String message = singletonMessages.iterator().next();
        boolean isNotMatchingAnyPattern = true;
        for (String pattern : patterns) {
            if (this.matchPattern(pattern, message)) {
                LOGGER.fine(() -> "Matched excluded message pattern: " + pattern + " for message: \"" + message + "\"");
                isNotMatchingAnyPattern = false;
                break;
            }
            LOGGER.fine(() -> "Not matching excluded message pattern: " + pattern + " for message: \"" + message + "\"");
        }
        if (isNotMatchingAnyPattern) {
            LOGGER.info(() -> "Message: \"" + message + "\" does not match any excluded message pattern [" + String.join((CharSequence)", ", patterns) + "], build should be triggered");
            return true;
        }
        LOGGER.info("Commit message matching excluded message pattern, skipping build");
        return false;
    }

    private boolean matchPattern(String pattern, String message) {
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(message);
        return matcher.find();
    }
}

