/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.workflow;

import com.google.inject.Inject;
import com.xebialabs.deployit.ci.workflow.DARPackageUtil;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;

public class XLDeployPackageStep
extends AbstractStepImpl {
    public final String darPath;
    public final String manifestPath;
    public final String artifactsPath;

    @DataBoundConstructor
    public XLDeployPackageStep(String artifactsPath, String manifestPath, String darPath) {
        this.manifestPath = manifestPath;
        this.darPath = darPath;
        this.artifactsPath = artifactsPath;
    }

    public XLDeployPackageStepDescriptor getDescriptor() {
        return (XLDeployPackageStepDescriptor)super.getDescriptor();
    }

    public static final class XLDeployPackageExecution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        @Inject
        private transient XLDeployPackageStep step;
        @StepContextParameter
        private transient EnvVars envVars;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient FilePath ws;

        protected Void run() throws Exception {
            DARPackageUtil packageUtil = new DARPackageUtil(this.step.artifactsPath, this.step.manifestPath, this.step.darPath, this.envVars);
            String packagePath = (String)this.ws.getChannel().call((Callable)packageUtil);
            this.listener.getLogger().println("XL Deploy package created : " + packagePath);
            return null;
        }
    }

    @Extension
    public static final class XLDeployPackageStepDescriptor
    extends AbstractStepDescriptorImpl {
        public XLDeployPackageStepDescriptor() {
            super(XLDeployPackageExecution.class);
        }

        public String getFunctionName() {
            return "xldCreatePackage";
        }

        public String getDisplayName() {
            return "Create a deployment package";
        }
    }
}

