/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.workflow;

import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.util.OverthereUtils;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileOutputStream;
import de.schlichtherle.truezip.file.TVFS;
import hudson.EnvVars;
import hudson.remoting.Callable;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jenkinsci.remoting.RoleChecker;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DARPackageUtil
implements Callable<String, IOException> {
    private static final String DEPLOYIT_MANIFEST_XML = "deployit-manifest.xml";
    private final String artifactsPath;
    private final String manifestPath;
    private final String darPath;
    private final String workspace;
    private final EnvVars envVars;

    public DARPackageUtil(String artifactsPath, String manifestPath, String darPath, EnvVars envVars) {
        this.artifactsPath = artifactsPath;
        this.manifestPath = manifestPath;
        this.darPath = envVars.expand(darPath);
        this.workspace = (String)envVars.get((Object)"WORKSPACE");
        this.envVars = envVars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String call() throws IOException {
        String manifestContent = this.replaceEnvVarInManifest();
        List<String> filePathsToBeAdded = this.filterFiles(manifestContent);
        String packagePath = this.outputFilePath();
        try {
            this.addManifest(packagePath);
            this.addArtifactsAndFolders(filePathsToBeAdded, packagePath);
        }
        finally {
            TVFS.umount();
        }
        return packagePath;
    }

    private void addArtifactsAndFolders(List<String> filePathsToBeAdded, String packagePath) throws FileNotFoundException {
        for (String filePath : filePathsToBeAdded) {
            File sourceFile = new File(this.workspace + File.separator + this.artifactsPath + File.separator + filePath);
            if (sourceFile.isDirectory()) {
                TFile targetFolder = new TFile(packagePath + File.separator + filePath);
                targetFolder.mkdirs();
                this.copyFolder(sourceFile, targetFolder);
                continue;
            }
            TFile artifactDir = new TFile(packagePath, this.stripFilePath(filePath), TArchiveDetector.ALL);
            artifactDir.mkdirs();
            this.copyFile(new FileInputStream(sourceFile), new TFile((File)artifactDir, sourceFile.getName(), TArchiveDetector.NULL));
        }
    }

    private void addManifest(String packagePath) throws FileNotFoundException {
        TFile entry = new TFile(packagePath + File.separator + DEPLOYIT_MANIFEST_XML);
        this.copyFile(new FileInputStream(new File(this.workspace + File.separator + this.manifestPath)), entry);
    }

    private String stripFilePath(String filePath) {
        return filePath.contains(File.separator) ? filePath.substring(0, filePath.lastIndexOf(File.separator)) : "";
    }

    private void copyFolder(File sourceFile, TFile targetFolder) throws FileNotFoundException {
        for (File file : sourceFile.listFiles()) {
            if (file.isFile()) {
                this.copyFile(new FileInputStream(file), new TFile((File)targetFolder, file.getName(), TArchiveDetector.NULL));
                continue;
            }
            if (!file.isDirectory()) continue;
            TFile targetFolder1 = new TFile((File)targetFolder, file.getName());
            targetFolder1.mkdirs();
            this.copyFolder(file, targetFolder1);
        }
    }

    private void copyFile(InputStream sourceFile, TFile targetFile) {
        try (InputStream is = sourceFile;
             TFileOutputStream os = new TFileOutputStream((File)targetFile);){
            OverthereUtils.write((InputStream)is, (OutputStream)os);
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    List<String> filterFiles(String manifestContent) {
        final ArrayList<String> files = new ArrayList<String>();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            DefaultHandler handler = new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    super.startElement(uri, localName, qName, attributes);
                    for (int index = 0; index < attributes.getLength(); ++index) {
                        if (!attributes.getQName(index).equals("file")) continue;
                        files.add(attributes.getValue(attributes.getQName(index)));
                    }
                }
            };
            saxParser.parse(new InputSource(new StringReader(manifestContent)), handler);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new IllegalArgumentException("Exception Occured while parsing deployit-manifest", e);
        }
        return files;
    }

    private String replaceEnvVarInManifest() throws IOException {
        String manifestContent;
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            Files.copy(Paths.get(this.workspace, this.manifestPath), outputStream);
            manifestContent = new String(outputStream.toByteArray());
        }
        manifestContent = this.envVars.expand(manifestContent);
        var3_2 = null;
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(this.workspace, this.manifestPath), StandardOpenOption.TRUNCATE_EXISTING);){
            writer.append(manifestContent);
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        return manifestContent;
    }

    private String outputFilePath() {
        return this.workspace + File.separator + this.darPath;
    }

    public void checkRoles(RoleChecker checker) throws SecurityException {
    }
}

