/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.server;

import java.io.IOException;
import java.io.Serializable;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreemptiveAuthenticationInterceptor
implements HttpRequestInterceptor,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreemptiveAuthenticationInterceptor.class);

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (request.getFirstHeader("Authorization") == null) {
            Credentials credentials;
            LOGGER.trace("No 'Authorization' header found for request: {}", (Object)request.getRequestLine());
            HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
            CredentialsProvider credentialsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
            if (credentialsProvider != null && (credentials = credentialsProvider.getCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()))) != null) {
                request.setHeader(new BasicScheme().authenticate(credentials, request, context));
                LOGGER.trace("Set 'Authorization' header {} for request: {}", (Object)credentials.getUserPrincipal(), (Object)request.getRequestLine());
            }
        }
    }
}

