/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.server;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.reflect.Reflection;
import com.xebialabs.deployit.booter.remote.BooterConfig;
import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.booter.remote.client.DeployitRemoteClient;
import com.xebialabs.deployit.ci.JenkinsDeploymentOptions;
import com.xebialabs.deployit.ci.server.DeployCommand;
import com.xebialabs.deployit.ci.server.DeployitDescriptorRegistry;
import com.xebialabs.deployit.ci.server.DeployitDescriptorRegistryImpl;
import com.xebialabs.deployit.ci.server.DeployitServer;
import com.xebialabs.deployit.ci.server.PluginFirstClassloaderInvocationHandler;
import com.xebialabs.deployit.ci.server.PreemptiveAuthenticationInterceptor;
import com.xebialabs.deployit.ci.util.JenkinsDeploymentListener;
import com.xebialabs.deployit.engine.api.DeploymentService;
import com.xebialabs.deployit.engine.api.RepositoryService;
import com.xebialabs.deployit.engine.api.TaskService;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.ServerInfo;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.List;
import org.apache.http.HttpRequestInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployitServerImpl
implements DeployitServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeployitServerImpl.class);
    private BooterConfig booterConfig;
    private DeployitDescriptorRegistry descriptorRegistry;
    private int poolSize;

    DeployitServerImpl(BooterConfig booterConfig) {
        this.booterConfig = booterConfig;
        BooterConfig newBooterConfig = BooterConfig.builder((BooterConfig)booterConfig).withConnectionPoolSize(this.poolSize).withHttpRequestInterceptor((HttpRequestInterceptor)new PreemptiveAuthenticationInterceptor()).withSocketTimeout(booterConfig.getSocketTimeout()).build();
        this.descriptorRegistry = (DeployitDescriptorRegistry)Reflection.newProxy(DeployitDescriptorRegistry.class, (InvocationHandler)new PluginFirstClassloaderInvocationHandler(new DeployitDescriptorRegistryImpl(newBooterConfig)));
    }

    private DeployitCommunicator getCommunicator() {
        return this.getDescriptorRegistry().getCommunicator();
    }

    @Override
    public void setConnectionPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    @Override
    public List<String> search(String type) {
        return this.search(type, null);
    }

    @Override
    public List<String> search(String type, String namePattern) {
        LOGGER.debug("search " + type);
        try {
            List result = this.getCommunicator().getProxies().getRepositoryService().query(this.getDescriptorRegistry().typeForName(type), null, null, namePattern, null, null, 0L, -1L);
            return Lists.transform((List)result, (Function)new Function<ConfigurationItemId, String>(){

                public String apply(ConfigurationItemId input) {
                    return input.getId();
                }
            });
        }
        catch (Exception e) {
            LOGGER.error(String.format("search fails for %s", type), (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public ConfigurationItem importPackage(String darFile) {
        DeployitCommunicator communicator = this.getCommunicator();
        ConfigurationItem ci = new DeployitRemoteClient(communicator).importPackage(darFile);
        return ci;
    }

    @Override
    public void deploy(String deploymentPackage, String environment, JenkinsDeploymentOptions deploymentOptions, JenkinsDeploymentListener listener) {
        DeploymentService deploymentService = this.getCommunicator().getProxies().getDeploymentService();
        TaskService taskService = this.getCommunicator().getProxies().getTaskService();
        RepositoryService repositoryService = this.getCommunicator().getProxies().getRepositoryService();
        new DeployCommand(deploymentService, taskService, repositoryService, deploymentOptions, listener).deploy(deploymentPackage, environment);
    }

    @Override
    public DeployitCommunicator newCommunicator() {
        return this.getCommunicator();
    }

    @Override
    public DeployitDescriptorRegistry getDescriptorRegistry() {
        return this.descriptorRegistry;
    }

    @Override
    public BooterConfig getBooterConfig() {
        return this.booterConfig;
    }

    @Override
    public void reload() {
        this.getDescriptorRegistry().reload();
    }

    @Override
    public ServerInfo getServerInfo() {
        return this.getCommunicator().getProxies().getServerService().getInfo();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeployitServerImpl that = (DeployitServerImpl)o;
        return this.booterConfig == null && that.booterConfig == null || this.booterConfig != null && this.booterConfig.equals((Object)that.booterConfig);
    }

    public int hashCode() {
        return this.booterConfig != null ? this.booterConfig.hashCode() : 0;
    }

    @Override
    public String getRegistryVersion() {
        return this.getDescriptorRegistry().getVersion();
    }
}

