/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.server;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.ci.DeployitPluginException;
import com.xebialabs.deployit.ci.JenkinsDeploymentOptions;
import com.xebialabs.deployit.ci.server.DeployitServerFactory;
import com.xebialabs.deployit.ci.util.JenkinsDeploymentListener;
import com.xebialabs.deployit.engine.api.DeploymentService;
import com.xebialabs.deployit.engine.api.RepositoryService;
import com.xebialabs.deployit.engine.api.TaskService;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.api.dto.ValidatedConfigurationItem;
import com.xebialabs.deployit.engine.api.execution.StepExecutionState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskState;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class DeployCommand {
    private DeploymentService deploymentService;
    private TaskService taskService;
    private JenkinsDeploymentOptions deploymentOptions;
    private JenkinsDeploymentListener listener;
    private RepositoryService repositoryService;

    DeployCommand(DeploymentService deploymentService, TaskService taskService, RepositoryService repositoryService, JenkinsDeploymentOptions deploymentOptions, JenkinsDeploymentListener listener) {
        this.deploymentService = deploymentService;
        this.taskService = taskService;
        this.repositoryService = repositoryService;
        this.deploymentOptions = deploymentOptions;
        this.listener = listener;
    }

    private void verifyPackageExistInRemoteRepository(String deploymentPackage) {
        boolean found = false;
        Type foundType = null;
        try {
            ConfigurationItem repoPackage = this.repositoryService.read(deploymentPackage);
            foundType = repoPackage.getType();
            this.listener.debug(String.format("Found CI '%s' as '%s' .", repoPackage, foundType));
        }
        catch (Throwable t) {
            String errorMsg = String.format("'%s' not found in repository.", deploymentPackage);
            throw new DeployitPluginException(errorMsg, t);
        }
        Type versionType = Type.valueOf((String)"udm.Version");
        if (!foundType.isSubTypeOf(versionType)) {
            String errorMsg = String.format("'%s' of type '%s' is not a deployment package. Please verify that 'Version' is specified in Jenkins configuration.", deploymentPackage, foundType);
            throw new DeployitPluginException(errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(String deploymentPackage, String environment) {
        Deployment deployment;
        boolean initialDeployment;
        this.listener.debug(this.deploymentOptions.toString());
        this.verifyPackageExistInRemoteRepository(deploymentPackage);
        boolean bl = initialDeployment = !this.deploymentService.isDeployed(DeployitServerFactory.getParentId(deploymentPackage), environment);
        if (initialDeployment) {
            this.listener.info("initial Deployment");
            deployment = this.deploymentService.prepareInitial(deploymentPackage, environment);
        } else {
            this.listener.info("upgrade Deployment");
            String deployedApplicationId = environment + "/" + DeployitServerFactory.getNameFromId(DeployitServerFactory.getParentId(deploymentPackage));
            deployment = this.deploymentService.prepareUpdate(deploymentPackage, deployedApplicationId);
        }
        if (this.deploymentOptions.generateDeployedOnUpgrade) {
            this.listener.debug("prepareAutoDeployeds");
            deployment = this.deploymentService.prepareAutoDeployeds(deployment);
        }
        this.listener.debug(" dump Deployeds");
        for (Object itemDto : deployment.getDeployeds()) {
            this.listener.debug(" - " + itemDto);
        }
        try {
            this.listener.debug("validate");
            deployment = this.deploymentService.validate(deployment);
        }
        catch (RuntimeException e) {
            this.listener.error(" RuntimeException: " + e.getMessage());
            if (!e.getMessage().contains("The task did not deliver any steps")) {
                throw new DeployitPluginException(e.getMessage(), e);
            }
            return;
        }
        int validationMessagesFound = 0;
        for (ConfigurationItem configurationItem : deployment.getDeployeds()) {
            if (!(configurationItem instanceof ValidatedConfigurationItem)) continue;
            for (ValidationMessage msg : ((ValidatedConfigurationItem)configurationItem).getValidations()) {
                this.listener.error(String.format("Validation error found on item '%s' of type '%s' on field '%s': %s, %s", configurationItem.getId(), configurationItem.getType(), msg.getCiId(), msg.getMessage(), configurationItem));
                this.listener.error(String.format(" %s", configurationItem));
                ++validationMessagesFound;
            }
        }
        if (validationMessagesFound > 0) {
            throw new DeployitPluginException(String.format("Validation errors (%d) have been found. For more information previously reported ERROR messages.", validationMessagesFound));
        }
        this.listener.debug("deploy");
        String taskId = this.deploymentService.createTask(deployment);
        try {
            this.executeTask(taskId);
        }
        catch (RuntimeException e) {
            try {
                if (this.deploymentOptions.rollbackOnError) {
                    this.listener.error("Deployment failed, performing a rollback");
                    this.executeTask(this.deploymentService.rollback(taskId));
                }
            }
            finally {
                throw new DeployitPluginException(e.getMessage());
            }
        }
    }

    private boolean executeTask(String taskId) {
        if (this.deploymentOptions.skipMode) {
            this.listener.info("skip mode, skip all the steps");
            this.taskService.skip(taskId, this.range(this.taskService.getTask(taskId).getNrSteps() + 1));
        }
        this.checkTaskState(taskId);
        if (this.deploymentOptions.testMode) {
            this.listener.info("test mode, cancel task " + taskId);
            this.taskService.cancel(taskId);
            return false;
        }
        try {
            this.listener.info("Start deployment task " + taskId);
            this.startTaskAndWait(taskId);
            this.checkTaskState(taskId);
            this.taskService.archive(taskId);
            return true;
        }
        catch (RuntimeException e) {
            String msg = String.format("Error when executing task %s", taskId);
            throw new DeployitPluginException(msg);
        }
    }

    private List<Integer> range(int end) {
        ArrayList result = Lists.newArrayList();
        for (int i = 1; i < end; ++i) {
            result.add(i);
        }
        return result;
    }

    private void checkTaskState(String taskId) {
        TaskState taskState = this.taskService.getTask(taskId);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss");
        this.listener.info(String.format("%s Description\t%s", taskId, taskState.getDescription()));
        this.listener.info(String.format("%s State      \t%s %d/%d", taskId, taskState.getState(), taskState.getCurrentStepNr(), taskState.getNrSteps()));
        if (taskState.getStartDate() != null) {
            GregorianCalendar startDate = taskState.getStartDate().toGregorianCalendar();
            this.listener.info(String.format("%s Start      %s", taskId, sdf.format(startDate.getTime())));
        }
        if (taskState.getCompletionDate() != null) {
            GregorianCalendar completionDate = taskState.getCompletionDate().toGregorianCalendar();
            this.listener.info(String.format("%s Completion %s", taskId, sdf.format(completionDate.getTime())));
        }
        StringBuilder sb = new StringBuilder();
        int stepCount = 0;
        for (StepState stepInfo : this.taskService.getSteps(taskId).getSteps()) {
            String description = stepInfo.getDescription();
            String log = stepInfo.getLog();
            String stepInfoMessage = StringUtils.isEmpty((String)log) || description.equals(log) ? String.format("%s step #%d %s\t%s", taskId, stepCount, stepInfo.getState(), description) : String.format("%s step #%d %s\t%s\n%s", taskId, stepCount, stepInfo.getState(), description, log);
            this.listener.info(stepInfoMessage);
            if (StepExecutionState.FAILED.equals((Object)stepInfo.getState())) {
                sb.append(stepInfoMessage);
            }
            ++stepCount;
        }
        if (taskState.getState().isExecutionHalted()) {
            throw new DeployitPluginException(String.format("Errors when executing task %s: %s", taskId, sb));
        }
    }

    private void startTaskAndWait(String taskId) {
        this.taskService.start(taskId);
        boolean done = false;
        int retryCount = 1;
        while (!done) {
            try {
                TaskState ti = this.taskService.getTask(taskId);
                TaskExecutionState state = ti.getState();
                this.listener.debug("Task state: " + state.toString());
                done = state.isPassiveAfterExecuting();
                retryCount = 1;
            }
            catch (Exception e) {
                if (retryCount == 6) {
                    Throwables.propagate((Throwable)e);
                }
                this.listener.info("Failed to get task status. Error message: " + Throwables.getRootCause((Throwable)e).getMessage());
                this.listener.info("Will attempt retry " + retryCount + " of 5 in one second.");
                ++retryCount;
            }
            try {
                this.listener.debug("Waiting for task to be done...");
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

